/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.device;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.kontakt.sdk.android.common.KontaktSDK;
import com.kontakt.sdk.android.common.profile.IBeaconRegion;
import com.kontakt.sdk.android.common.util.SDKPreconditions;
import java.io.Serializable;
import java.util.UUID;

public class BeaconRegion
implements IBeaconRegion {
    public static final Parcelable.Creator<BeaconRegion> CREATOR = new Parcelable.Creator<BeaconRegion>(){

        public BeaconRegion createFromParcel(Parcel source) {
            Bundle bundle = source.readBundle(this.getClass().getClassLoader());
            return new Builder().proximity((UUID)bundle.getSerializable("uuid")).secureProximity((UUID)bundle.getSerializable("secureUuid")).major(bundle.getInt("major")).minor(bundle.getInt("minor")).identifier(bundle.getString("identifier")).build();
        }

        public BeaconRegion[] newArray(int size) {
            return new BeaconRegion[size];
        }
    };
    public static final int ANY_MAJOR = -1;
    public static final int ANY_MINOR = -1;
    public static final BeaconRegion EVERYWHERE = new Builder().identifier("Everywhere").proximity(KontaktSDK.DEFAULT_KONTAKT_BEACON_PROXIMITY_UUID).secureProximity(null).major(-1).minor(-1).build();
    private final UUID proximity;
    private final UUID secureProximity;
    private final int major;
    private final int minor;
    private final String identifier;

    public static Builder builder() {
        return new Builder();
    }

    BeaconRegion(Builder builder) {
        SDKPreconditions.checkNotNull(builder.identifier, "Identifier cannot be null");
        SDKPreconditions.checkArgument(builder.proximity != null || builder.secureProximity != null, "Proximity is not set");
        this.proximity = builder.proximity;
        this.secureProximity = builder.secureProximity;
        this.major = builder.major;
        this.minor = builder.minor;
        this.identifier = builder.identifier;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BeaconRegion that = (BeaconRegion)o;
        if (this.major != that.major) {
            return false;
        }
        if (this.minor != that.minor) {
            return false;
        }
        if (this.proximity != null ? !this.proximity.equals(that.proximity) : that.proximity != null) {
            return false;
        }
        if (this.secureProximity != null ? !this.secureProximity.equals(that.secureProximity) : that.secureProximity != null) {
            return false;
        }
        return this.identifier.equals(that.identifier);
    }

    public int hashCode() {
        int result = this.proximity != null ? this.proximity.hashCode() : 0;
        result = 31 * result + (this.secureProximity != null ? this.secureProximity.hashCode() : 0);
        result = 31 * result + this.major;
        result = 31 * result + this.minor;
        result = 31 * result + this.identifier.hashCode();
        return result;
    }

    public String toString() {
        StringBuilder region = new StringBuilder();
        region.append("[");
        if (this.proximity != null) {
            region.append(this.proximity);
        } else if (this.secureProximity != null) {
            region.append(this.secureProximity);
        }
        region.append(", ");
        if (this.major == -1) {
            region.append("ANY_MAJOR");
        } else {
            region.append(this.major);
        }
        region.append(", ");
        if (this.minor == -1) {
            region.append("ANY_MINOR");
        } else {
            region.append(this.minor);
        }
        region.append("]");
        return region.toString();
    }

    @Override
    public UUID getProximity() {
        return this.proximity;
    }

    @Override
    public UUID getSecureProximity() {
        return this.secureProximity;
    }

    @Override
    public int getMajor() {
        return this.major;
    }

    @Override
    public int getMinor() {
        return this.minor;
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    public void writeToParcel(Parcel dest, int flags) {
        Bundle bundle = new Bundle(this.getClass().getClassLoader());
        bundle.putSerializable("uuid", (Serializable)this.proximity);
        bundle.putSerializable("secureUuid", (Serializable)this.secureProximity);
        bundle.putInt("major", this.major);
        bundle.putInt("minor", this.minor);
        bundle.putString("identifier", this.identifier);
        dest.writeBundle(bundle);
    }

    public int describeContents() {
        return 0;
    }

    public static class Builder {
        UUID proximity;
        UUID secureProximity;
        int major = -1;
        int minor = -1;
        String identifier;

        public Builder proximity(UUID proximity) {
            this.proximity = proximity;
            return this;
        }

        public Builder secureProximity(UUID secureProximity) {
            this.secureProximity = secureProximity;
            return this;
        }

        public Builder major(int major) {
            this.major = major;
            return this;
        }

        public Builder minor(int minor) {
            this.minor = minor;
            return this;
        }

        public Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public BeaconRegion build() {
            return new BeaconRegion(this);
        }
    }
}

