/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.connection;

import android.util.Base64;
import com.kontakt.sdk.android.ble.security.exception.InvalidConfigException;
import com.kontakt.sdk.android.ble.security.parser.DataResponseParser;
import com.kontakt.sdk.android.ble.security.parser.PropertyHelper;
import com.kontakt.sdk.android.ble.security.property.AbstractProperty;
import com.kontakt.sdk.android.ble.security.property.ByteArrayProperty;
import com.kontakt.sdk.android.ble.security.property.Int8Property;
import com.kontakt.sdk.android.ble.security.property.PropertyID;
import com.kontakt.sdk.android.ble.security.property.StringProperty;
import com.kontakt.sdk.android.ble.security.property.UInt16Property;
import com.kontakt.sdk.android.ble.security.property.UInt32Property;
import com.kontakt.sdk.android.common.model.Config;
import com.kontakt.sdk.android.common.model.PacketType;
import com.kontakt.sdk.android.common.model.PowerSaving;
import com.kontakt.sdk.android.common.model.PowerSavingFeature;
import com.kontakt.sdk.android.common.profile.DeviceProfile;
import com.kontakt.sdk.android.common.util.ConversionUtils;
import com.kontakt.sdk.android.common.util.EddystoneUtils;
import com.kontakt.sdk.android.common.util.SDKPreconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.TimeUnit;

class SecureConfigMapper {
    static final int IBEACON_PROFILE = 1;
    static final int EDDYSTONE_PROFILE = 2;
    static final long DEFAULT_SHUFFLE_INTERVAL = TimeUnit.HOURS.toMinutes(24L);
    private static final float ADV_INTERVAL_FACTOR = 0.625f;
    private static final int DEFAULT_MOVE_SUSPEND_TIMEOUT = 6000;
    private static final int UID_BIT = 1;
    private static final int URL_BIT = 2;
    private static final int TLM_BIT = 4;
    private static final int IBEACON_BIT = 8;
    private static final int KONTAKT_PROFILE_BIT = 16;
    private static final int EID_BIT = 32;
    private static final int ETLM_BIT = 64;
    private static final int MOTION_SENSOR_BIT = 1;
    private static final int LIGHT_SENSOR_BIT = 2;
    private static final int SMART_BEACON_RSSI_SIZE = 8;
    private static final int CARD_BEACON_RSSI_SIZE = 2;
    private static final int PRO_BEACON_RSSI_SIZE = 7;

    SecureConfigMapper() {
    }

    static Config fromReadResponse(String beaconPassword, String response) {
        SDKPreconditions.checkNotNull(response, "Response can't be null");
        SDKPreconditions.checkNotNull(response, "Beacon password can't be null");
        byte[] decodedBase = Base64.decode((String)response, (int)0);
        try {
            DataResponseParser parser = DataResponseParser.parse(decodedBase, beaconPassword);
            List<AbstractProperty<?>> properties = parser.getProperties();
            Config.Builder builder = new Config.Builder();
            PowerSaving.Builder powerSavingBuilder = new PowerSaving.Builder();
            for (AbstractProperty<?> property : properties) {
                SecureConfigMapper.readProperty(builder, powerSavingBuilder, property);
            }
            return builder.powerSaving(powerSavingBuilder.build()).build();
        }
        catch (InvalidConfigException e) {
            return null;
        }
    }

    static List<AbstractProperty<?>> toSecureProperties(Config config) {
        String password;
        String url;
        String instanceId;
        String namespace;
        String name;
        SDKPreconditions.checkNotNull(config, "Config is null");
        SecureConfigMapper.validate(config);
        ArrayList properties = new ArrayList();
        if (config.getInterval() > 0) {
            properties.add(new UInt16Property(PropertyID.INTERVAL, (int)((float)config.getInterval() / 0.625f)));
        }
        if (config.getTxPower() >= 0) {
            properties.add(new Int8Property(PropertyID.TX_POWER, ConversionUtils.fromPowerLevelToDbm(config.getTxPower())));
        }
        if (config.getMajor() > 0) {
            properties.add(new UInt16Property(PropertyID.MAJOR, config.getMajor()));
        }
        if (config.getMinor() > 0) {
            properties.add(new UInt16Property(PropertyID.MINOR, config.getMinor()));
        }
        if (config.getProximity() != null) {
            properties.add(new ByteArrayProperty(PropertyID.PROXIMITY_UUID, config.getProximity()));
        }
        if ((name = config.getName()) != null && !name.trim().isEmpty()) {
            properties.add(new StringProperty(PropertyID.NAME, name));
        }
        if ((namespace = config.getNamespace()) != null && !namespace.trim().isEmpty()) {
            properties.add(new ByteArrayProperty(PropertyID.NAMESPACE_ID, namespace));
        }
        if ((instanceId = config.getInstanceId()) != null && !instanceId.trim().isEmpty()) {
            properties.add(new ByteArrayProperty(PropertyID.INSTANCE_ID, instanceId));
        }
        if ((url = config.getUrl()) != null && !url.trim().isEmpty()) {
            properties.add(new ByteArrayProperty(PropertyID.URL, config.getHexUrl()));
        }
        if ((password = config.getPassword()) != null && !password.trim().isEmpty()) {
            properties.add(new StringProperty(PropertyID.SET_PASSWORD, password));
        }
        if (config.getShuffled() != null) {
            if (config.isShuffled()) {
                properties.add(new UInt16Property(PropertyID.SHUFFLE_INTERVAL, (int)DEFAULT_SHUFFLE_INTERVAL));
            } else {
                properties.add(new UInt16Property(PropertyID.SHUFFLE_INTERVAL, 0));
            }
        }
        SecureConfigMapper.putProfiles(config, properties);
        SecureConfigMapper.putPackets(config, properties);
        SecureConfigMapper.putPowerSaving(config, properties);
        SecureConfigMapper.putRssi(PropertyID.REF_TX_0M, config, properties);
        SecureConfigMapper.putRssi(PropertyID.REF_TX_1M, config, properties);
        return properties;
    }

    private static void putRssi(PropertyID propertyID, Config config, List<AbstractProperty<?>> properties) {
        List<Integer> rssi;
        SDKPreconditions.checkArgument(propertyID == PropertyID.REF_TX_0M || propertyID == PropertyID.REF_TX_1M);
        List<Integer> list = rssi = propertyID == PropertyID.REF_TX_0M ? config.getRssi0m() : config.getRssi1m();
        if (rssi != null && !rssi.isEmpty()) {
            properties.add(new ByteArrayProperty(propertyID, SecureConfigMapper.normalizeRssi(rssi)));
        }
    }

    private static void putProfiles(Config config, List<AbstractProperty<?>> properties) {
        List<DeviceProfile> profiles = config.getProfiles();
        if (profiles != null && !profiles.isEmpty()) {
            if (profiles.contains((Object)DeviceProfile.IBEACON)) {
                properties.add(new Int8Property(PropertyID.ACTIVE_PROFILE, 1));
            } else if (profiles.contains((Object)DeviceProfile.EDDYSTONE)) {
                properties.add(new Int8Property(PropertyID.ACTIVE_PROFILE, 2));
            }
        }
    }

    private static void putPackets(Config config, List<AbstractProperty<?>> properties) {
        List<PacketType> packets = config.getPackets();
        if (packets != null && !packets.isEmpty()) {
            int mask = 16;
            if (packets.contains((Object)PacketType.EDDYSTONE_UID)) {
                mask |= 1;
            }
            if (packets.contains((Object)PacketType.EDDYSTONE_URL)) {
                mask |= 2;
            }
            if (packets.contains((Object)PacketType.EDDYSTONE_TLM)) {
                mask |= 4;
            }
            if (packets.contains((Object)PacketType.IBEACON)) {
                mask |= 8;
            }
            if (packets.contains((Object)PacketType.EDDYSTONE_EID)) {
                mask |= 0x20;
            }
            if (packets.contains((Object)PacketType.EDDYSTONE_ETLM)) {
                mask |= 0x40;
            }
            properties.add(new UInt32Property(PropertyID.BEACON_PACKETS_MASK, mask));
        }
    }

    private static void putPowerSaving(Config config, List<AbstractProperty<?>> properties) {
        PowerSaving powerSaving = config.getPowerSaving();
        if (powerSaving == null) {
            return;
        }
        List<PowerSavingFeature> features = powerSaving.getFeatures();
        if (features != null) {
            int mask = 0;
            if (features.contains((Object)PowerSavingFeature.MOTION_DETECTION)) {
                mask |= 1;
                properties.add(new UInt32Property(PropertyID.MOVE_SUSPEND_TIMEOUT, 6000));
            }
            if (features.contains((Object)PowerSavingFeature.LIGHT_SENSOR)) {
                mask |= 2;
            }
            properties.add(new UInt32Property(PropertyID.POWER_SAVER_FEATURES_MASK, mask));
        }
        if (powerSaving.getLightSensorThreshold() != -1) {
            properties.add(new Int8Property(PropertyID.LIGHT_SENSOR_THRESHOLD, powerSaving.getLightSensorThreshold()));
        }
        if (powerSaving.getLightSensorHysteresis() != -1) {
            properties.add(new Int8Property(PropertyID.LIGHT_SENSOR_HIST, powerSaving.getLightSensorHysteresis()));
        }
        if (powerSaving.getLightSensorSamplingInterval() != -1L) {
            properties.add(new UInt32Property(PropertyID.LIGHT_SENSOR_SAMPLING_INTERVAL, (int)powerSaving.getLightSensorSamplingInterval()));
        }
    }

    private static void readProperty(Config.Builder builder, PowerSaving.Builder powerSavingBuilder, AbstractProperty<?> property) {
        switch (property.getPropertyID()) {
            case BEACON_ID: {
                builder.uniqueId(PropertyHelper.readString(property));
                break;
            }
            case INTERVAL: {
                builder.interval((int)((float)PropertyHelper.readInt16(property) * 0.625f));
                break;
            }
            case TX_POWER: {
                builder.txPower(ConversionUtils.toPowerLevel(PropertyHelper.readInt8(property)));
                break;
            }
            case PROXIMITY_UUID: {
                builder.proximity(PropertyHelper.readUUID(property));
                break;
            }
            case MAJOR: {
                builder.major(PropertyHelper.readInt16(property));
                break;
            }
            case MINOR: {
                builder.minor(PropertyHelper.readInt16(property));
                break;
            }
            case NAME: {
                builder.name(PropertyHelper.readString(property));
                break;
            }
            case NAMESPACE_ID: {
                builder.namespace(EddystoneUtils.toHexString(property.getBytes()));
                break;
            }
            case INSTANCE_ID: {
                builder.instanceId(EddystoneUtils.toHexString(property.getBytes()));
                break;
            }
            case URL: {
                builder.url(EddystoneUtils.toHexString(property.getBytes()));
                break;
            }
            case SHUFFLE_INTERVAL: {
                builder.shuffled(PropertyHelper.readInt16(property) > 0);
                break;
            }
            case BEACON_PACKETS_MASK: {
                SecureConfigMapper.readPackets(builder, PropertyHelper.readUInt32(property));
                break;
            }
            case ACTIVE_PROFILE: {
                SecureConfigMapper.readProfile(builder, PropertyHelper.readInt8(property));
                break;
            }
            case POWER_SAVER_FEATURES_MASK: {
                SecureConfigMapper.readPowerSaving(powerSavingBuilder, PropertyHelper.readUInt32(property));
                break;
            }
            case LIGHT_SENSOR_THRESHOLD: {
                powerSavingBuilder.lightSensorThreshold(PropertyHelper.readInt8(property));
                break;
            }
            case LIGHT_SENSOR_HIST: {
                powerSavingBuilder.lightSensorHysteresis(PropertyHelper.readInt8(property));
                break;
            }
            case LIGHT_SENSOR_SAMPLING_INTERVAL: {
                powerSavingBuilder.lightSensorSamplingInterval(PropertyHelper.readUInt32(property));
                break;
            }
            case MOVE_SUSPEND_TIMEOUT: {
                powerSavingBuilder.moveSuspendTimeout(PropertyHelper.readUInt32(property));
                break;
            }
            case SET_PASSWORD: {
                builder.password(PropertyHelper.readString(property));
            }
        }
    }

    private static void readPackets(Config.Builder builder, int bytes) {
        ArrayList<PacketType> packets = new ArrayList<PacketType>();
        if ((bytes & 1) != 0) {
            packets.add(PacketType.EDDYSTONE_UID);
        }
        if ((bytes & 2) != 0) {
            packets.add(PacketType.EDDYSTONE_URL);
        }
        if ((bytes & 4) != 0) {
            packets.add(PacketType.EDDYSTONE_TLM);
        }
        if ((bytes & 8) != 0) {
            packets.add(PacketType.IBEACON);
        }
        if ((bytes & 0x10) != 0) {
            packets.add(PacketType.KONTAKT);
        }
        if ((bytes & 0x20) != 0) {
            packets.add(PacketType.EDDYSTONE_EID);
        }
        if ((bytes & 0x40) != 0) {
            packets.add(PacketType.EDDYSTONE_TLM);
        }
        builder.packets(packets);
    }

    private static void readProfile(Config.Builder builder, int value) {
        if (value == 1) {
            builder.profiles(Collections.singletonList(DeviceProfile.IBEACON));
        } else if (value == 2) {
            builder.profiles(Collections.singletonList(DeviceProfile.EDDYSTONE));
        }
    }

    private static void readPowerSaving(PowerSaving.Builder builder, int bytes) {
        ArrayList<PowerSavingFeature> features = new ArrayList<PowerSavingFeature>();
        if ((bytes & 1) != 0) {
            features.add(PowerSavingFeature.MOTION_DETECTION);
        }
        if ((bytes & 2) != 0) {
            features.add(PowerSavingFeature.LIGHT_SENSOR);
        }
        builder.features(features);
    }

    private static void validate(Config config) {
        List<DeviceProfile> profiles = config.getProfiles();
        if (profiles != null && profiles.size() > 1) {
            throw new IllegalArgumentException("Only single profile can be set at a time");
        }
        PowerSaving powerSaving = config.getPowerSaving();
        if (powerSaving != null && powerSaving.getFeatures() != null && powerSaving.getFeatures().containsAll(EnumSet.of(PowerSavingFeature.LIGHT_SENSOR, PowerSavingFeature.MOTION_DETECTION))) {
            throw new IllegalArgumentException("Setting both Light Sensor and Motion Detection is not allowed");
        }
        SecureConfigMapper.checkRssiArray(config.getRssi0m(), "Provided RSSI @ 0m array has invalid size.");
        SecureConfigMapper.checkRssiArray(config.getRssi1m(), "Provided RSSI @ 1m array has invalid size.");
    }

    private static void checkRssiArray(List<Integer> rssi, String message) {
        if (rssi != null && !rssi.isEmpty() && rssi.size() != 2 && rssi.size() != 8 && rssi.size() != 7) {
            throw new IllegalArgumentException(message);
        }
    }

    private static List<Integer> normalizeRssi(List<Integer> inputRssi) {
        int i;
        ArrayList<Integer> normalized = new ArrayList<Integer>();
        if (inputRssi.size() == 8) {
            normalized.addAll(inputRssi);
        }
        if (inputRssi.size() == 2) {
            for (i = 0; i <= 7; ++i) {
                if (i == 1) {
                    normalized.add(inputRssi.get(0));
                    continue;
                }
                if (i == 6) {
                    normalized.add(inputRssi.get(1));
                    continue;
                }
                normalized.add(0);
            }
        }
        if (inputRssi.size() == 7) {
            normalized.add(0);
            for (i = 0; i <= 6; ++i) {
                normalized.add(inputRssi.get(i));
            }
        }
        return normalized;
    }
}

