/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.connection;

import android.util.Base64;
import com.kontakt.sdk.android.ble.connection.ErrorCause;
import com.kontakt.sdk.android.ble.connection.ReadListener;
import com.kontakt.sdk.android.ble.connection.SecureConfigMapper;
import com.kontakt.sdk.android.ble.security.ResponseCode;
import com.kontakt.sdk.android.ble.security.exception.InvalidConfigException;
import com.kontakt.sdk.android.ble.security.parser.SimpleResponseParser;
import com.kontakt.sdk.android.common.model.Config;

class ReadAllListener
implements ReadListener<Config> {
    private static final ReadListener<Config> NOOP_LISTENER = new ReadListener<Config>(){

        @Override
        public void onReadSuccess(Config value) {
        }

        @Override
        public void onReadFailure(ErrorCause cause) {
        }
    };
    private final String beaconPassword;
    private final ReadListener<Config> wrappedListener;

    public static ReadAllListener create(ReadListener<Config> readListener, String beaconPassword) {
        return new ReadAllListener(readListener, beaconPassword);
    }

    public static ReadAllListener noop() {
        return new ReadAllListener(NOOP_LISTENER, null);
    }

    private ReadAllListener(ReadListener<Config> readListener, String beaconPassword) {
        this.beaconPassword = beaconPassword;
        this.wrappedListener = readListener;
    }

    @Override
    public void onReadSuccess(Config config) {
        this.wrappedListener.onReadSuccess(config);
    }

    @Override
    public void onReadFailure(ErrorCause cause) {
        this.wrappedListener.onReadFailure(cause);
    }

    public void onResponseReceived(String response) {
        if (this.wrappedListener == NOOP_LISTENER) {
            return;
        }
        if (response == null || response.isEmpty()) {
            this.wrappedListener.onReadFailure(ErrorCause.INCORRECT_RESPONSE);
            return;
        }
        if (!this.checkResponse(response)) {
            return;
        }
        Config parsedConfig = SecureConfigMapper.fromReadResponse(this.beaconPassword, response);
        if (parsedConfig != null) {
            this.wrappedListener.onReadSuccess(parsedConfig);
        } else {
            this.wrappedListener.onReadFailure(ErrorCause.INCORRECT_RESPONSE);
        }
    }

    boolean checkResponse(String response) {
        byte[] decodedBase = Base64.decode((String)response, (int)0);
        try {
            SimpleResponseParser responseParser = SimpleResponseParser.of(decodedBase, this.beaconPassword);
            ResponseCode result = responseParser.getResult();
            switch (result) {
                case OK: {
                    return true;
                }
                case VERIFICATION_FAILED: {
                    this.wrappedListener.onReadFailure(ErrorCause.VERIFICATION_FAILED);
                    return false;
                }
                case AUTHORIZATION_FAILED: {
                    this.wrappedListener.onReadFailure(ErrorCause.AUTHORIZATION_FAILED);
                    return false;
                }
                case ID_NOT_FOUND: {
                    this.wrappedListener.onReadFailure(ErrorCause.ID_NOT_FOUND);
                    return false;
                }
            }
            this.wrappedListener.onReadFailure(ErrorCause.INCORRECT_RESPONSE);
            return false;
        }
        catch (InvalidConfigException e) {
            this.wrappedListener.onReadFailure(ErrorCause.INCORRECT_RESPONSE);
            return false;
        }
    }
}

