/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.connection;

import android.content.Context;
import android.os.RemoteException;
import com.kontakt.sdk.android.ble.connection.GattController;
import com.kontakt.sdk.android.ble.connection.KontaktDeviceConnectionImpl;
import com.kontakt.sdk.android.ble.connection.NormalGattController;
import com.kontakt.sdk.android.ble.connection.SecureGattController;
import com.kontakt.sdk.android.common.FirmwareRevisions;
import com.kontakt.sdk.android.common.profile.RemoteBluetoothDevice;

final class GattControllerFactory {
    GattControllerFactory() {
    }

    static GattController createGattController(KontaktDeviceConnectionImpl kontaktDeviceConnection, Context context, RemoteBluetoothDevice remoteBluetoothDevice) throws RemoteException {
        String firmwareVersion = remoteBluetoothDevice.getFirmwareVersion();
        if (FirmwareRevisions.SECURE_MODE_FIRMWARE_VERSIONS.contains(firmwareVersion)) {
            return new SecureGattController(kontaktDeviceConnection, context, remoteBluetoothDevice);
        }
        if (FirmwareRevisions.NORMAL_MODE_FIRMWARE_VERSIONS.contains(firmwareVersion)) {
            return new NormalGattController(kontaktDeviceConnection, context, remoteBluetoothDevice);
        }
        return new SecureGattController(kontaktDeviceConnection, context, remoteBluetoothDevice);
    }
}

