/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.configuration;

import com.kontakt.sdk.android.ble.configuration.ActivityCheckConfiguration;
import com.kontakt.sdk.android.ble.configuration.ForceScanConfiguration;
import com.kontakt.sdk.android.ble.configuration.ScanPeriod;
import com.kontakt.sdk.android.ble.filter.eddystone.EddystoneFilter;
import com.kontakt.sdk.android.ble.filter.ibeacon.IBeaconFilter;
import com.kontakt.sdk.android.common.profile.IBeaconRegion;
import com.kontakt.sdk.android.common.profile.IEddystoneNamespace;
import com.kontakt.sdk.android.common.util.SDKPreconditions;
import java.util.Collection;
import java.util.List;

final class ScanContextValidator {
    private static final int MAX_FILTERS_SIZE = 10;
    private static final int REGIONS_LIMIT = 20;

    private ScanContextValidator() {
    }

    static void validate(ActivityCheckConfiguration activityCheckConfiguration) {
        long minimalInactivityTimeout;
        if (activityCheckConfiguration == ActivityCheckConfiguration.MINIMAL || activityCheckConfiguration == ActivityCheckConfiguration.DISABLED) {
            return;
        }
        long inactivityTimeout = activityCheckConfiguration.getInactivityTimeout();
        SDKPreconditions.checkArgument(inactivityTimeout >= (minimalInactivityTimeout = ActivityCheckConfiguration.MINIMAL.getInactivityTimeout()), "The inactivity timeout must be no shorter than 3 seconds");
        long checkPeriod = activityCheckConfiguration.getCheckPeriod();
        long minimalCheckPeriod = ActivityCheckConfiguration.MINIMAL.getCheckPeriod();
        SDKPreconditions.checkArgument(checkPeriod >= minimalCheckPeriod, "The check period must be no shorter than 1 second");
    }

    static void validate(ForceScanConfiguration forceScanConfiguration) {
        if (forceScanConfiguration == ForceScanConfiguration.DISABLED) {
            return;
        }
        ForceScanConfiguration minimalConfig = ForceScanConfiguration.MINIMAL;
        long minimalActivePeriod = minimalConfig.getForceScanActivePeriod();
        if (forceScanConfiguration.getForceScanActivePeriod() < minimalActivePeriod) {
            throw new IllegalArgumentException(String.format("The Force Scan Active period must not be shorter than %d milliseconds", minimalActivePeriod));
        }
        long minimalPassivePeriod = minimalConfig.getForceScanPassivePeriod();
        if (forceScanConfiguration.getForceScanPassivePeriod() < minimalPassivePeriod) {
            throw new IllegalArgumentException(String.format("The Force Scan Passive period must not be shorter than %d", minimalPassivePeriod));
        }
    }

    static void validate(ScanPeriod scanPeriod) {
        long activePeriod = scanPeriod.getActivePeriod();
        SDKPreconditions.checkArgument(activePeriod >= ScanPeriod.MINIMAL_ACTIVE_SCAN_PERIOD, String.format("Active scan period should last no shorter than %d seconds", ScanPeriod.MINIMAL_ACTIVE_SCAN_PERIOD / 1000L));
        long passiveSubPeriod = scanPeriod.getPassivePeriod();
        SDKPreconditions.checkArgument(passiveSubPeriod == 0L || passiveSubPeriod >= ScanPeriod.MINIMAL_PASSIVE_SCAN_PERIOD, "Unsupported ScanPeriod's passive period");
    }

    static void validate(ActivityCheckConfiguration activityCheckConfiguration, ScanPeriod scanPeriod) {
        if (scanPeriod != ScanPeriod.RANGING) {
            SDKPreconditions.checkArgument(activityCheckConfiguration.getCheckPeriod() < scanPeriod.getActivePeriod(), "Activity check period must be longer than active scan period");
        }
    }

    static void validateIBeaconRegionsCount(Collection<IBeaconRegion> iBeaconRegions) {
        SDKPreconditions.checkNotNull(iBeaconRegions, "Regions are null");
        SDKPreconditions.checkArgument(iBeaconRegions.size() <= 20, "You can range beacons within max 20 regions.");
    }

    static void validateIBeaconFiltersCount(List<IBeaconFilter> filters) {
        SDKPreconditions.checkNotNull(filters, "IBeacon filters are null");
        SDKPreconditions.checkState(filters.size() <= 10, "Too many iBeacon filters specified. The limit is 10");
    }

    static void validateEddystoneFiltersCount(List<EddystoneFilter> eddystoneFilterList) {
        SDKPreconditions.checkNotNull(eddystoneFilterList, "Eddystone filters are null");
        SDKPreconditions.checkState(eddystoneFilterList.size() <= 10, "Too many eddystone filters specified. The limit is 10");
    }

    static void validateNamespacesCount(Collection<IEddystoneNamespace> eddystoneNamespaceSet) {
        SDKPreconditions.checkNotNull(eddystoneNamespaceSet, "Eddystone namespaces are null");
        SDKPreconditions.checkArgument(eddystoneNamespaceSet.size() <= 20, "You can range eddystones within max 20 namespaces.");
    }
}

