package com.kontakt.sdk.android.common.util;

import android.text.TextUtils;
import android.util.Patterns;

public final class EddystonePropertyValidator {

  private EddystonePropertyValidator() {
  }

  public static void validateUrl(String url) {
    boolean validUrl = Patterns.WEB_URL.matcher(url).matches();
    if (!validUrl) {
      throw new IllegalArgumentException("url is not valid");
    }
    byte[] bytes = EddystoneUtils.serializeUrl(url);
    if (bytes.length == 0) {
      throw new IllegalArgumentException("url is empty");
    }
    if (bytes.length > Constants.Eddystone.URL_MAX_BYTES_LENGTH) {
      throw new IllegalArgumentException("url length is over " + Constants.Eddystone.URL_MAX_BYTES_LENGTH + " bytes length");
    }
  }

  public static void validateStringWithLessLength(String string, String what, int length) {
    SDKPreconditions.checkArgument(string != null, what + " cannot be null");
    SDKPreconditions.checkArgument(!string.isEmpty(), what + " cannot be empty");
    SDKPreconditions.checkArgument(string.getBytes().length <= length, what + " cannot be larger than " + length + " bytes");
  }

  public static void validateStringWithExactLength(String string, String message, int length) {
    SDKPreconditions.checkArgument(string != null, message + " cannot be null");
    SDKPreconditions.checkArgument(!string.isEmpty(), message + " cannot be empty");
    SDKPreconditions.checkArgument(string.getBytes().length == length, message + " must be " + length + " bytes");
  }

  public static void validateInstanceId(byte[] hexedStringBytes) {
    SDKPreconditions.checkArgument(hexedStringBytes.length == Constants.Eddystone.INSTANCE_MAX_BYTES_LENGTH, "InstanceId wrong bytes length");
  }

  public static void validateNamespace(byte[] hexedStringBytes) {
    SDKPreconditions.checkArgument(hexedStringBytes.length == Constants.Eddystone.NAMESPACE_MAX_BYTES_LENGTH, "Namespace wrong bytes length");
  }

  public static void validateHexString(String string) {
    SDKPreconditions.checkArgument(!TextUtils.isEmpty(string), "Hex String is empty");
    SDKPreconditions.checkArgument(EddystoneUtils.isStringOnlyHex(string), "String is not in hex format");
  }
}
