package com.kontakt.sdk.android.common.model;

/**
 * Enumeration type of device model.
 */
public enum Model {

  /**
   * Smart beacon device model.
   */
  SMART_BEACON,

  /**
   * USB beacon device model.
   */
  USB_BEACON,

  /**
   * Sensor beacon device model.
   */
  SENSOR_BEACON,

  /**
   * Cloud beacon device model.
   */
  CLOUD_BEACON,

  /**
   * Card beacon device model.
   */
  CARD_BEACON,

  /**
   * External device model.
   */
  EXTERNAL,

  /**
   * Gateway device model.
   */
  GATEWAY,

  /**
   * Beacon PRO device model.
   */
  BEACON_PRO;

  public static Model fromString(String modelString) {
    if (modelString != null) {
      for (Model model : Model.values()) {
        if (modelString.equalsIgnoreCase(model.name())) {
          return model;
        }
      }
    }
    return SMART_BEACON;
  }
}
