package com.kontakt.sdk.android.common.model;

import android.os.Parcelable;
import java.util.List;

/**
 * Interface for resolved device IDs from API. It consists of:
 * <br>
 * <br>queriedBy - device ID which was used to HTTP request
 * <br>resolved - resolved device ID
 * <br>uniqueId - unique ID of resolved device
 * <br>futureIds - set of device IDs which will be transmitted in the future
 *
 * @param <DEVICE_ID> - iBeacon or Eddystone ID
 */
public interface IFutureId<DEVICE_ID> extends Parcelable {
  String QUERIED_BY = "queriedBy";
  String RESOLVED = "resolved";
  String FUTURE_SHUFFLES = "futureId";
  String UNIQUE_ID = "uniqueId";

  DEVICE_ID getQueriedBy();

  DEVICE_ID getResolved();

  List<DEVICE_ID> getFutureIds();

  String getUniqueId();
}
