package com.kontakt.sdk.android.cloud.util;

import com.kontakt.sdk.android.cloud.response.CloudError;
import java.io.IOException;
import java.lang.annotation.Annotation;
import okhttp3.ResponseBody;
import retrofit2.Converter;
import retrofit2.Response;
import retrofit2.Retrofit;

/**
 * Utility class purposed for extracting and building {@code CloudError} instances from response objects.
 */
public final class ErrorUtils {

  private static Retrofit retrofit;

  private ErrorUtils() {
    // prevent from creation
  }

  /**
   * Initializes static retrofit instance. It should be called once, before any others
   * interactions with this class.
   *
   * @param retrofit the retrofit instance.
   */
  public static void initialize(final Retrofit retrofit) {
    ErrorUtils.retrofit = retrofit;
  }

  /**
   * Extracts an error from the response object.
   *
   * @param response the response object.
   * @return new instance of {@code CloudError}.
   */
  public static CloudError parseError(Response<?> response) {
    Converter<ResponseBody, CloudError> converter = retrofit.responseBodyConverter(CloudError.class, new Annotation[0]);

    CloudError error;
    try {
      error = converter.convert(response.errorBody());
    } catch (IOException e) {
      return new CloudError(null, -1, e.getMessage());
    }

    return error;
  }
}
