package com.kontakt.sdk.android.cloud.response.paginated;

import com.google.gson.annotations.SerializedName;
import com.kontakt.sdk.android.common.model.Trigger;
import java.util.List;

/**
 * Triggers API response representation composed of triggers list and search meta data.
 */
public class Triggers extends PaginatedResponse<List<Trigger>> {

  @SerializedName("triggers") protected List<Trigger> triggers;

  /**
   * Returns the trigger list.
   *
   * @return the trigger list.
   */
  @Override
  public List<Trigger> getContent() {
    return triggers;
  }
}
