package com.kontakt.sdk.android.cloud.response;

import android.text.TextUtils;

/**
 * All resources that return lists of elements can be paged. If we execute such a request, there will
 * be the searchMeta field in the JSON response with the structure covered by this class.
 */
public final class SearchMeta {

  private int startIndex;
  private int maxResult;
  private String nextResults;
  private String prevResults;

  public int getStartIndex() {
    return startIndex;
  }

  public int getMaxResult() {
    return maxResult;
  }

  public String getPreviousResultsURI() {
    return prevResults;
  }

  public boolean hasNextResultsURI() {
    return !TextUtils.isEmpty(nextResults);
  }

  public String getNextResultsURI() {
    return nextResults;
  }
}
