package com.kontakt.sdk.android.cloud.response;

/**
 * A container for error details retrieved from Kontakt.io Proximity REST API.
 */
public class CloudError {

  private final String id;
  private final int status;
  private final String message;
  private Details[] details;

  /**
   * Constructs new instance of {@code CloudError} initialized with id, status and error message.
   *
   * @param id the identifier.
   * @param status the status code.
   * @param message the error message.
   */
  public CloudError(String id, int status, String message) {
    this.id = id;
    this.status = status;
    this.message = message;
  }

  public String getId() {
    return id;
  }

  public int getStatus() {
    return status;
  }

  public String getMessage() {
    return details != null ? details[0].message : message;
  }

  public Details[] getDetails() {
    return details;
  }

  /**
   * Nested container that holds more detailed info about the error.
   */
  public class Details {
    private final String field;
    private final String error;
    final String message;

    /**
     * Constructs new instance of {@code CloudError.Details}.
     *
     * @param field the field.
     * @param error the error.
     * @param message the message.
     */
    public Details(String field, String error, String message) {
      this.field = field;
      this.error = error;
      this.message = message;
    }

    public String getField() {
      return field;
    }

    public String getError() {
      return error;
    }

    public String getMessage() {
      return message;
    }
  }
}
