package com.kontakt.sdk.android.cloud.api.service;

import com.kontakt.sdk.android.cloud.response.paginated.Venues;
import com.kontakt.sdk.android.common.model.Venue;
import java.util.Map;
import okhttp3.ResponseBody;
import retrofit2.Call;
import retrofit2.http.FieldMap;
import retrofit2.http.FormUrlEncoded;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.POST;
import retrofit2.http.Path;
import retrofit2.http.QueryMap;

public interface VenuesService {

  @GET("/venue/{id}")
  Call<Venue> getVenue(@Path("id") String id);

  @GET("/venue")
  Call<Venues> getVenues(@QueryMap Map<String, String> params);

  @GET("/venue")
  Call<Venues> getVenues(@QueryMap Map<String, String> params, @Header("If-None-Match") String eTag);

  @GET("/venue/{id}/image")
  Call<ResponseBody> getVenueImage(@Path("id") String id);

  @FormUrlEncoded
  @POST("/venue/create")
  Call<Venue> createVenue(@FieldMap Map<String, String> params);

  @FormUrlEncoded
  @POST("/venue/update")
  Call<String> updateVenue(@FieldMap Map<String, String> params);

  @FormUrlEncoded
  @POST("/venue/delete")
  Call<String> deleteVenue(@FieldMap Map<String, String> params);

  @FormUrlEncoded
  @POST("/venue/share")
  Call<String> shareVenue(@FieldMap Map<String, String> params);

  @FormUrlEncoded
  @POST("/venue/unshare")
  Call<String> unshareVenue(@FieldMap Map<String, String> params);
}
