package com.kontakt.sdk.android.cloud.api.service;

import com.kontakt.sdk.android.cloud.response.paginated.Actions;
import com.kontakt.sdk.android.common.model.Action;
import java.util.Map;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import retrofit2.Call;
import retrofit2.http.FieldMap;
import retrofit2.http.FormUrlEncoded;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Multipart;
import retrofit2.http.POST;
import retrofit2.http.Part;
import retrofit2.http.Path;
import retrofit2.http.QueryMap;

public interface ActionsService {

  @GET("/action")
  Call<Actions> getActions(@QueryMap Map<String, String> params);

  @GET("/action")
  Call<Actions> getActions(@QueryMap Map<String, String> params, @Header("If-None-Match") String eTag);

  @GET("/action/{id}/content")
  Call<ResponseBody> getContentActionFile(@Path("id") String id);

  @FormUrlEncoded
  @POST("/action/create")
  Call<Action> createAction(@FieldMap Map<String, String> params);

  @Multipart
  @POST("/action/create")
  Call<Action> createContentActionWithMultipart(@Part("uniqueId") RequestBody uniqueId, @Part("actionType") RequestBody actionType,
      @Part("proximity") RequestBody proximity, @Part MultipartBody.Part file);

  @FormUrlEncoded
  @POST("/action/update")
  Call<String> updateAction(@FieldMap Map<String, String> params);

  @FormUrlEncoded
  @POST("/action/delete")
  Call<String> deleteAction(@FieldMap Map<String, String> params);
}
