package com.kontakt.sdk.android.cloud.api.executor.venues;

import com.kontakt.sdk.android.cloud.api.VenuesApi;
import com.kontakt.sdk.android.cloud.api.executor.FileRequestExecutor;
import com.kontakt.sdk.android.cloud.api.service.VenuesService;
import java.util.UUID;
import okhttp3.ResponseBody;
import retrofit2.Call;

/**
 * Request executor provided by {@link VenuesApi}. Use this class if you want to fetch
 * venue's image file, for example:
 * <pre>
 *   <code>
 *   KontaktCloud kontaktCloud = KontaktCloudFactory.create();
 *   FileData imageFile = kontaktCloud.venues().imageOf(venueID).execute();
 *   </code>
 * </pre>
 */
public class VenueImageRequestExecutor extends FileRequestExecutor {

  private final VenuesService venuesService;

  private final UUID id;

  /**
   * Constructs request executor initialized with corresponding service class and venue's id.
   *
   * @param venuesService the actions API service.
   * @param id the venue's unique identifier.
   */
  public VenueImageRequestExecutor(final VenuesService venuesService, final UUID id) {
    this.venuesService = venuesService;
    this.id = id;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected Call<ResponseBody> prepareCall() {
    return venuesService.getVenueImage(id.toString());
  }
}
