package com.kontakt.sdk.android.cloud.api.executor;

import com.kontakt.sdk.android.cloud.exception.KontaktCloudException;
import com.kontakt.sdk.android.cloud.response.CloudCallback;
import com.kontakt.sdk.android.common.FileData;
import java.io.IOException;
import okhttp3.ResponseBody;
import retrofit2.Call;
import retrofit2.Response;

public abstract class FileRequestExecutor {

  public FileData execute() throws IOException, KontaktCloudException {
    final Call<ResponseBody> call = prepareCall();
    final Response<ResponseBody> response = call.execute();
    if (response.isSuccessful()) {
      final ResponseBody body = response.body();
      if (body == null) {
        return FileData.empty();
      }
      return FileData.of(body.bytes());
    }
    final String rawMessage = response.raw().message();
    final int code = response.code();
    final String message = "code - " + code + ", message - " + rawMessage;
    throw new KontaktCloudException(message, code);
  }

  public void execute(CloudCallback<FileData> callback) {
    final Call<ResponseBody> call = prepareCall();
    call.enqueue(new FileDataCallbackWrapper(callback));
  }

  /**
   * Prepares a request to execute.
   *
   * @return the request.
   */
  protected abstract Call<ResponseBody> prepareCall();
}
