package com.kontakt.sdk.android.ble.security.property;

import static com.kontakt.sdk.android.common.util.SDKPreconditions.checkArgument;

public class UInt16Property extends AbstractProperty<Short> {
  private static final int UINT16_SIZE = 2;
  private int value;

  public UInt16Property(PropertyID id, int value) {
    super(id);
    this.value = value;
  }

  public UInt16Property(PropertyID id, byte[] value) {
    super(id);
    checkArgument(value.length == UINT16_SIZE);
    this.value = (value[0] & 0xFF) + ((value[1] << 8) & 0xFF00);
  }

  /**
   * @return Little endian value
   */
  @Override
  public byte[] getBytes() {
    byte[] result = new byte[2];
    result[0] = (byte) (value & 0x00FF);
    result[1] = (byte) ((value & 0xFF00) >>> Byte.SIZE);
    return result;
  }

  @Override
  public byte getSize() {
    return UINT16_SIZE;
  }

  @Override
  public Short getValue() {
    return (short) value;
  }
}
