package com.kontakt.sdk.android.ble.security.property;

import com.kontakt.sdk.android.common.util.ArrayUtils;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.UUID;

import static com.kontakt.sdk.android.common.util.ConversionUtils.hexStringToByteArray;

public class ByteArrayProperty extends AbstractProperty<byte[]> {
  private static final int UUID_LENGTH = 16;
  private final byte[] value;

  public ByteArrayProperty(PropertyID id, byte[] value) {
    super(id);
    this.value = value;
  }

  public ByteArrayProperty(PropertyID id, UUID uuid) {
    super(id);
    this.value = ByteBuffer.allocate(UUID_LENGTH).putLong(uuid.getMostSignificantBits()).putLong(uuid.getLeastSignificantBits()).array();
  }

  public ByteArrayProperty(PropertyID id, String value) {
    super(id);
    this.value = hexStringToByteArray(value);
  }

  public ByteArrayProperty(PropertyID id, List<Integer> int8Array) {
    super(id);
    Byte[] bytes = new Byte[int8Array.size()];
    for (int i = 0; i < int8Array.size(); i++) {
      Integer integer = int8Array.get(i);
      bytes[i] = integer.byteValue();
    }
    this.value = ArrayUtils.toPrimitive(bytes);
  }

  @Override
  public byte[] getBytes() {
    return value;
  }

  @Override
  public byte getSize() {
    return (byte) value.length;
  }

  @Override
  public byte[] getValue() {
    return value;
  }
}
