package com.kontakt.sdk.android.ble.security;

public enum Operation {
  WRITE(0x10),
  READ(0x20),
  READ_ALL(0x21),
  COMMAND(0x30);

  private byte value;

  Operation(int value) {
    this.value = (byte) value;
  }

  public byte getValue() {
    return value;
  }

  public static Operation of(byte value) {
    Operation[] arr = values();
    int len = arr.length;

    for (int i = 0; i < len; i++) {
      if (arr[i].getValue() == value) {
        return arr[i];
      }
    }
    return null;
  }
}
