package com.kontakt.sdk.android.ble.security;

public class EncryptedReadAllRequest extends ReadAllRequest {
  private final String password;

  public EncryptedReadAllRequest(int token, String password) {
    super(Flag.ENCRYPTED_REQUEST, token);
    this.password = password;
  }

  @Override
  protected byte[] getPayload() {
    byte[] dataToEncrypt = new byte[] { 0x00 };
    dataToEncrypt = PayloadEncrypter.align(dataToEncrypt, 16, null);
    return PayloadEncrypter.encryptPayload(dataToEncrypt, password, token);
  }
}
