package com.kontakt.sdk.android.ble.rssi;

import com.kontakt.sdk.android.common.Proximity;

/**
 * Rssi calculator was designed to manipulate RSSI signal and parameter
 * directly dependent on it - {@link Proximity}.
 * Proper calculation of Rssi is significant from the point of view
 * of dynamic actions search.
 */
public interface RssiCalculator {

  /**
   * Calculates rssi.
   *
   * @param uniqueKey the unique key
   * @param rssi the rssi
   * @return the double
   */
  int calculateRssi(final int uniqueKey, final int rssi);

  /**
   * Clears employed resources.
   */
  void clear();

  /**
   * Clears employed resources for specified unique key.
   *
   * @param uniqueKey the unique key
   */
  void clear(final int uniqueKey);
}
