package com.kontakt.sdk.android.ble.discovery.eddystone;

import com.kontakt.sdk.android.ble.spec.Telemetry;
import com.kontakt.sdk.android.common.util.ConversionUtils;

final class TLMResolver implements EddystonePropertyResolver<Telemetry> {

  static final int TLM_START_INDEX = 3;
  private static final int SCAN_RECORD_TLM_LENGTH = 13;

  @Override
  public Telemetry parse(byte[] packet) throws IllegalArgumentException {
    if (packet == null) {
      return null;
    }

    byte[] bytes = ConversionUtils.extractEddystonePacketPayload(packet, TLM_START_INDEX, SCAN_RECORD_TLM_LENGTH);
    if (bytes == null) {
      return null;
    }

    final int version = bytes[0] & 0x00FF;

    final byte[] batteryVoltage = new byte[] {
        bytes[1], bytes[2]
    };

    final int batteryVoltageValue = ConversionUtils.asInt(batteryVoltage);

    final byte[] tempVoltage = new byte[] {
        bytes[3], bytes[4]
    };

    final double tempVoltageValue = (ConversionUtils.asInt(tempVoltage) * 1.0) / 256;

    final byte[] advertisingPduCount = new byte[] {
        bytes[5], bytes[6], bytes[7], bytes[8]
    };

    final int advertisingPduCountValue = ConversionUtils.asInt(advertisingPduCount);

    final byte[] timeSincePowerUp = new byte[] {
        bytes[9], bytes[10], bytes[11], bytes[12]
    };

    final int timeSincePowerUpValue = ConversionUtils.asInt(timeSincePowerUp) / 10;

    return new Telemetry.Builder().batteryVoltage(batteryVoltageValue)
        .temperature(tempVoltageValue)
        .timeSincePowerUp(timeSincePowerUpValue)
        .pduCount(advertisingPduCountValue)
        .version(version)
        .build();
  }
}
