package com.kontakt.sdk.android.ble.dfu;

/**
 * Enum representing single Kontakt DFU command
 */
enum KDFUCommand {

  /**
   * Indicates start of image chunk transmission.
   */
  START_TRANSACTION((byte) 0x10),
  /**
   * Indicates transaction end. DFU Controller will respond with state change according to transaction result (success or failure).
   */
  FINALIZE_TRANSACTION((byte) 0x20),
  /**
   * Erase stored data.
   */
  ERASE((byte) 0x30),
  /**
   * Activates stored firmware image.
   */
  ACTIVATE((byte) 0x40),
  /**
   * Causes 80 bytes to be transmitted over data notifications on Data Characteristic.
   * First 16 bytes are: protocol_version(4), written image length(4), reserved(8).
   * Following bytes are 64 byte header of partially written image.
   */
  GET_STATE((byte) 0x50);

  private final byte code;

  public static KDFUCommand fromCode(byte code) {
    for (KDFUCommand kdfuCommand : KDFUCommand.values()) {
      if(kdfuCommand.getCode() == code) {
        return kdfuCommand;
      }
    }
    return null;
  }

  KDFUCommand(byte code) {
    this.code = code;
  }

  public byte getCode() {
    return code;
  }

  public byte[] getCodeAsArray() {
    return new byte[] { code };
  }
}
