package com.kontakt.sdk.android.ble.connection;

import com.kontakt.sdk.android.ble.exception.IllegalOperationException;
import com.kontakt.sdk.android.common.FirmwareRevisions;
import com.kontakt.sdk.android.common.profile.RemoteBluetoothDevice;

enum OperationType {
  NOOP,
  CONFIG,
  PROFILE,
  MINOR,
  MAJOR,
  NON_CONNECTABLE_MODE,
  PROXIMITY_UUID,
  PASSWORD,
  MODEL_NAME,
  ADVERTISING_INTERVAL,
  POWER_LEVEL,
  DEVICE_PROFILE,
  RESET,
  DFU,
  URL,
  NAMESPACE,
  INSTANCE_ID,
  RESTORE,
  AUTHORIZATION(true, false),
  READ_TIME(true, true),
  SYNC_TIME(true, true),
  READ_LIGHT_SENSOR(true, true),
  SECURE_CONFIG(true, false),
  SECURE_COMMAND(true, false);

  private boolean secureOnly;
  private boolean beaconProOnly;

  OperationType(boolean secure, boolean beaconProOnly) {
    this.secureOnly = secure;
    this.beaconProOnly = beaconProOnly;
  }

  OperationType() {
    this.secureOnly = false;
    this.beaconProOnly = false;
  }

  public void validate(RemoteBluetoothDevice device) {
    String deviceFirmware = device.getFirmwareVersion();
    if (secureOnly) {
      boolean isNormalMode = FirmwareRevisions.NORMAL_MODE_FIRMWARE_VERSIONS.contains(deviceFirmware);
      boolean isSecureMode = FirmwareRevisions.SECURE_MODE_FIRMWARE_VERSIONS.contains(deviceFirmware);
      boolean isBeaconProMode = FirmwareRevisions.BEACON_PRO_FIRMWARE_VERSIONS.contains(deviceFirmware);
      if (!isSecureMode) {
        if (isNormalMode) {
          throw new IllegalOperationException("Operation not available. Device firmware: " + deviceFirmware);
        }
      } else if (beaconProOnly && !isBeaconProMode) {
        throw new IllegalOperationException("Operation only available for Beacon Pro devices. Device firmware: " + deviceFirmware);
      } else if (READ_LIGHT_SENSOR == this && !FirmwareRevisions.BEACON_PRO_RTC_LIGHTSENSOR_FIRMWARE_VERSIONS.contains(deviceFirmware)) {
        throw new IllegalOperationException(
            "Operation only available for Beacon Pro devices with firmware 1.7 or higher. Device firmware: " + deviceFirmware);
      }
    } else {
      if (!FirmwareRevisions.NORMAL_MODE_FIRMWARE_VERSIONS.contains(deviceFirmware)) {
        throw new IllegalOperationException("Operation not available. Device firmware: " + deviceFirmware);
      }
    }
  }
}
