/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.common.model;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.gson.annotations.SerializedName;
import com.kontakt.sdk.android.common.model.EddystoneUid;
import com.kontakt.sdk.android.common.model.IBeaconId;
import com.kontakt.sdk.android.common.model.SecureProfileUid;
import com.kontakt.sdk.android.common.util.HashCodeBuilder;
import com.kontakt.sdk.android.common.util.SDKEqualsBuilder;
import com.kontakt.sdk.android.common.util.SDKPreconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Shuffles
implements Parcelable {
    public static final Parcelable.Creator<Shuffles> CREATOR = new Parcelable.Creator<Shuffles>(){

        public Shuffles createFromParcel(Parcel source) {
            return new Shuffles(source);
        }

        public Shuffles[] newArray(int size) {
            return new Shuffles[size];
        }
    };
    @SerializedName(value="EDDYSTONE")
    private List<EddystoneUid> eddystoneShuffles;
    @SerializedName(value="IBEACON")
    private List<IBeaconId> iBeaconShuffles;

    private Shuffles() {
        this(new Builder());
    }

    public static Builder builder() {
        return new Builder();
    }

    Shuffles(Builder builder) {
        this.eddystoneShuffles = builder.eddystoneShuffles;
        this.iBeaconShuffles = builder.iBeaconShuffles;
    }

    protected Shuffles(Parcel in) {
        this.eddystoneShuffles = in.createTypedArrayList(EddystoneUid.CREATOR);
        this.iBeaconShuffles = in.createTypedArrayList(IBeaconId.CREATOR);
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof Shuffles)) {
            return false;
        }
        if (o == this) {
            return true;
        }
        Shuffles other = (Shuffles)o;
        return SDKEqualsBuilder.start().equals(this.eddystoneShuffles, other.eddystoneShuffles).equals(this.iBeaconShuffles, other.iBeaconShuffles).result();
    }

    public int hashCode() {
        return HashCodeBuilder.init().append(this.eddystoneShuffles).append(this.iBeaconShuffles).build();
    }

    public List<EddystoneUid> getEddystoneShuffles() {
        return this.eddystoneShuffles;
    }

    public List<IBeaconId> getIBeaconShuffles() {
        return this.iBeaconShuffles;
    }

    public List<SecureProfileUid> getSecureProfileShuffles() {
        if (this.eddystoneShuffles != null) {
            ArrayList<SecureProfileUid> secureProfileUids = new ArrayList<SecureProfileUid>(this.eddystoneShuffles.size());
            for (EddystoneUid eddystoneShuffle : this.eddystoneShuffles) {
                secureProfileUids.add(SecureProfileUid.fromEddystoneUid(eddystoneShuffle));
            }
            return secureProfileUids;
        }
        return new ArrayList<SecureProfileUid>();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeTypedList(this.eddystoneShuffles);
        dest.writeTypedList(this.iBeaconShuffles);
    }

    public static class Builder {
        List<EddystoneUid> eddystoneShuffles = new ArrayList<EddystoneUid>();
        List<IBeaconId> iBeaconShuffles = new ArrayList<IBeaconId>();

        public Builder eddystoneShuffles(Collection<EddystoneUid> eddystoneShuffles) {
            SDKPreconditions.checkNotNull(eddystoneShuffles, "eddystone IDs cannot be null");
            for (EddystoneUid eddystoneUid : eddystoneShuffles) {
                SDKPreconditions.checkNotNull(eddystoneUid, "eddystone IDs cannot contain null value");
            }
            this.eddystoneShuffles.clear();
            this.eddystoneShuffles.addAll(eddystoneShuffles);
            return this;
        }

        public Builder iBeaconShuffles(Collection<IBeaconId> iBeaconShuffles) {
            SDKPreconditions.checkNotNull(iBeaconShuffles, "iBeacon IDs cannot be null");
            for (IBeaconId iBeaconId : iBeaconShuffles) {
                SDKPreconditions.checkNotNull(iBeaconId, "iBeacon IDs cannot contain null value");
            }
            this.iBeaconShuffles.clear();
            this.iBeaconShuffles.addAll(iBeaconShuffles);
            return this;
        }

        public Shuffles build() {
            return new Shuffles(this);
        }
    }
}

