/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.common.model;

import com.kontakt.sdk.android.common.model.EddystoneUid;
import com.kontakt.sdk.android.common.model.IBeaconId;
import com.kontakt.sdk.android.common.model.SecureProfileUid;
import com.kontakt.sdk.android.common.profile.DeviceProfile;
import com.kontakt.sdk.android.common.util.HashCodeBuilder;
import com.kontakt.sdk.android.common.util.SDKEqualsBuilder;
import com.kontakt.sdk.android.common.util.SDKPreconditions;
import java.io.Serializable;
import java.util.UUID;

public class ResolvedId
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String ID_SEPARATOR = ":";
    private final DeviceProfile deviceProfile;
    private final String uniqueId;
    private final String deviceId;
    private Integer hashCode;

    public static ResolvedId create(String deviceId, String uniqueId, DeviceProfile deviceProfile) {
        return new ResolvedId(deviceId, uniqueId, deviceProfile);
    }

    private ResolvedId(String deviceId, String uniqueId, DeviceProfile deviceProfile) {
        this.deviceId = deviceId;
        this.uniqueId = uniqueId;
        this.deviceProfile = deviceProfile;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof ResolvedId)) {
            return false;
        }
        if (o == this) {
            return true;
        }
        ResolvedId resolvedId = (ResolvedId)o;
        return SDKEqualsBuilder.start().equals(this.deviceId, resolvedId.deviceId).equals(this.uniqueId, resolvedId.uniqueId).equals((Object)this.deviceProfile, (Object)resolvedId.deviceProfile).result();
    }

    public int hashCode() {
        if (this.hashCode == null) {
            this.hashCode = HashCodeBuilder.init().append(this.deviceId).append(this.uniqueId).build();
        }
        return this.hashCode;
    }

    public String toString() {
        return "ResolvedId{deviceProfile=" + (Object)((Object)this.deviceProfile) + ", uniqueId='" + this.uniqueId + '\'' + ", deviceId='" + this.deviceId + '\'' + '}';
    }

    public IBeaconId getIBeaconId() {
        String[] splittedBeaconId = this.deviceId.split(ID_SEPARATOR);
        SDKPreconditions.checkArgument(splittedBeaconId.length == 3, "Incorrect iBeacon ID format!");
        UUID proximity = UUID.fromString(splittedBeaconId[0]);
        int major = Integer.parseInt(splittedBeaconId[1]);
        int minor = Integer.parseInt(splittedBeaconId[2]);
        return IBeaconId.of(proximity, major, minor);
    }

    public EddystoneUid getEddystoneUID() {
        String[] splittedEddystoneUID = this.deviceId.split(ID_SEPARATOR);
        SDKPreconditions.checkArgument(splittedEddystoneUID.length == 2, "Incorrect eddystone UID format!");
        String namespace = splittedEddystoneUID[0];
        String instanceId = splittedEddystoneUID[1];
        return EddystoneUid.of(namespace, instanceId);
    }

    public SecureProfileUid getSecureProfileUID() {
        String[] splitted = this.deviceId.split(ID_SEPARATOR);
        SDKPreconditions.checkArgument(splitted.length == 2, "Incorrect secure profile UID format!");
        String namespace = splitted[0];
        String instanceId = splitted[1];
        return SecureProfileUid.of(namespace, instanceId);
    }

    public DeviceProfile getDeviceProfile() {
        return this.deviceProfile;
    }

    public String getUniqueId() {
        return this.uniqueId;
    }
}

