/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.common.model;

import android.os.Parcel;
import android.os.Parcelable;
import com.kontakt.sdk.android.common.model.EddystoneUid;
import com.kontakt.sdk.android.common.model.IFutureId;
import com.kontakt.sdk.android.common.util.HashCodeBuilder;
import com.kontakt.sdk.android.common.util.SDKEqualsBuilder;
import com.kontakt.sdk.android.common.util.SDKPreconditions;
import java.util.ArrayList;
import java.util.List;

public class EddystoneFutureUID
implements IFutureId<EddystoneUid> {
    public static final Parcelable.Creator<EddystoneFutureUID> CREATOR = new Parcelable.Creator<EddystoneFutureUID>(){

        public EddystoneFutureUID createFromParcel(Parcel source) {
            return new EddystoneFutureUID(source);
        }

        public EddystoneFutureUID[] newArray(int size) {
            return new EddystoneFutureUID[size];
        }
    };
    private String uniqueId;
    private EddystoneUid queriedBy;
    private EddystoneUid resolved;
    private List<EddystoneUid> futureIds;

    public static Builder builder() {
        return new Builder();
    }

    EddystoneFutureUID(Builder builder) {
        this.uniqueId = builder.uniqueId;
        this.queriedBy = builder.queriedBy;
        this.resolved = builder.resolved;
        this.futureIds = builder.futureIds;
    }

    protected EddystoneFutureUID(Parcel in) {
        this.uniqueId = in.readString();
        this.queriedBy = (EddystoneUid)in.readParcelable(EddystoneUid.class.getClassLoader());
        this.resolved = (EddystoneUid)in.readParcelable(EddystoneUid.class.getClassLoader());
        this.futureIds = in.createTypedArrayList(EddystoneUid.CREATOR);
    }

    @Override
    public EddystoneUid getQueriedBy() {
        return this.queriedBy;
    }

    @Override
    public EddystoneUid getResolved() {
        return this.resolved;
    }

    @Override
    public List<EddystoneUid> getFutureIds() {
        return this.futureIds;
    }

    @Override
    public String getUniqueId() {
        return this.uniqueId;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof EddystoneFutureUID)) {
            return false;
        }
        if (o == this) {
            return true;
        }
        EddystoneFutureUID other = (EddystoneFutureUID)o;
        return SDKEqualsBuilder.start().equals(this.resolved, other.resolved).equals(this.queriedBy, other.queriedBy).equals(this.futureIds, other.futureIds).equals(this.uniqueId, other.uniqueId).result();
    }

    public int hashCode() {
        return HashCodeBuilder.init().append(this.resolved).append(this.queriedBy).append(this.futureIds).append(this.uniqueId).build();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.uniqueId);
        dest.writeParcelable((Parcelable)this.queriedBy, flags);
        dest.writeParcelable((Parcelable)this.resolved, flags);
        dest.writeTypedList(this.futureIds);
    }

    public static class Builder {
        String uniqueId;
        EddystoneUid queriedBy;
        EddystoneUid resolved;
        List<EddystoneUid> futureIds = new ArrayList<EddystoneUid>();

        public Builder uniqueId(String uniqueId) {
            this.uniqueId = uniqueId;
            return this;
        }

        public Builder queriedBy(EddystoneUid queriedBy) {
            this.queriedBy = queriedBy;
            return this;
        }

        public Builder resolved(EddystoneUid resolved) {
            this.resolved = resolved;
            return this;
        }

        public Builder futureIds(List<EddystoneUid> futureIds) {
            SDKPreconditions.checkNotNull(futureIds, "future IDs cannot be null");
            this.futureIds.clear();
            this.futureIds.addAll(futureIds);
            return this;
        }

        public EddystoneFutureUID build() {
            return new EddystoneFutureUID(this);
        }
    }
}

