/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.cloud.api.executor.venues;

import com.kontakt.sdk.android.cloud.api.executor.RequestExecutor;
import com.kontakt.sdk.android.cloud.api.service.VenuesService;
import com.kontakt.sdk.android.cloud.exception.KontaktCloudException;
import com.kontakt.sdk.android.cloud.response.CloudCallback;
import com.kontakt.sdk.android.cloud.util.StringUtils;
import com.kontakt.sdk.android.common.model.Access;
import com.kontakt.sdk.android.common.util.SDKPreconditions;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import retrofit2.Call;

public class ShareVenueRequestExecutor
extends RequestExecutor<String> {
    private final VenuesService venuesService;
    private final UUID[] ids;
    private String[] managerEmails;
    private Access access;
    private long expirationDate = -1L;
    private boolean withMetaData;

    public ShareVenueRequestExecutor(VenuesService venuesService, UUID ... ids) {
        this.venuesService = venuesService;
        this.ids = ids;
    }

    public ShareVenueRequestExecutor(VenuesService venuesService, List<UUID> ids) {
        this.venuesService = venuesService;
        int size = ids.size();
        this.ids = ids.toArray(new UUID[size]);
    }

    public ShareVenueRequestExecutor toManagers(String ... managerEmails) {
        SDKPreconditions.checkNotNull(managerEmails, "manager emails cannot be null");
        this.managerEmails = managerEmails;
        return this;
    }

    public ShareVenueRequestExecutor toManagers(List<String> managerEmails) {
        SDKPreconditions.checkNotNull(managerEmails, "manager emails cannot be null");
        int size = managerEmails.size();
        this.managerEmails = managerEmails.toArray(new String[size]);
        return this;
    }

    public ShareVenueRequestExecutor withAccess(Access access) {
        SDKPreconditions.checkNotNull(access, "access cannot be null");
        SDKPreconditions.checkState(access == Access.VIEWER || access == Access.EDITOR, "cannot share venue with " + access.name() + " access - should be VIEWER or EDITOR");
        this.access = access;
        return this;
    }

    public ShareVenueRequestExecutor expirationDate(long expirationDate) {
        SDKPreconditions.checkState(expirationDate > 0L, "expiration date cannot be negative");
        this.expirationDate = expirationDate;
        return this;
    }

    public ShareVenueRequestExecutor withMetaData(boolean withMetaData) {
        this.withMetaData = withMetaData;
        return this;
    }

    @Override
    public String execute() throws IOException, KontaktCloudException {
        this.checkPreconditions();
        return (String)super.execute();
    }

    @Override
    public void execute(CloudCallback<String> callback) {
        this.checkPreconditions();
        super.execute(callback);
    }

    @Override
    protected Call<String> prepareCall() {
        return this.venuesService.shareVenue(this.params());
    }

    private void checkPreconditions() {
        SDKPreconditions.checkState(this.managerEmails != null, "cannot share venue - specify managers");
        SDKPreconditions.checkState(this.access != null, "cannot share venue - specify access");
    }

    @Override
    protected Map<String, String> params() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("venueId", StringUtils.join(this.ids, ","));
        params.put("managerMail", StringUtils.join(this.managerEmails, ","));
        params.put("access", this.access.name());
        params.put("withMetaData", String.valueOf(this.withMetaData));
        if (this.expirationDate >= 0L) {
            params.put("expirationDate", String.valueOf(this.expirationDate));
        }
        return params;
    }
}

