/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.cloud.api.executor.devices;

import com.kontakt.sdk.android.cloud.api.executor.RequestExecutor;
import com.kontakt.sdk.android.cloud.api.service.DevicesService;
import com.kontakt.sdk.android.cloud.exception.KontaktCloudException;
import com.kontakt.sdk.android.cloud.response.CloudCallback;
import com.kontakt.sdk.android.cloud.util.StringUtils;
import com.kontakt.sdk.android.common.util.SDKPreconditions;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import retrofit2.Call;

public class MoveDeviceRequestExecutor
extends RequestExecutor<String> {
    private final DevicesService devicesService;
    private final String[] uniqueIds;
    private String managerEmail;
    private UUID companyId;

    public MoveDeviceRequestExecutor(DevicesService devicesService, String ... uniqueIds) {
        this.devicesService = devicesService;
        this.uniqueIds = uniqueIds;
    }

    public MoveDeviceRequestExecutor(DevicesService devicesService, List<String> uniqueIds) {
        this.devicesService = devicesService;
        int size = uniqueIds.size();
        this.uniqueIds = uniqueIds.toArray(new String[size]);
    }

    public MoveDeviceRequestExecutor toManager(String managerEmail) {
        SDKPreconditions.checkNotNull(managerEmail, "manager email cannot be null");
        this.managerEmail = managerEmail;
        return this;
    }

    public MoveDeviceRequestExecutor toCompany(UUID companyId) {
        SDKPreconditions.checkNotNull(companyId, "company ID cannot be null");
        this.companyId = companyId;
        return this;
    }

    @Override
    public String execute() throws IOException, KontaktCloudException {
        this.checkPreconditions();
        return (String)super.execute();
    }

    @Override
    public void execute(CloudCallback<String> callback) {
        this.checkPreconditions();
        super.execute(callback);
    }

    @Override
    protected Call<String> prepareCall() {
        return this.devicesService.moveDevice(this.params());
    }

    private void checkPreconditions() {
        SDKPreconditions.checkState(this.managerEmail != null, "cannot move beacon - specify manager");
    }

    @Override
    protected Map<String, String> params() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("uniqueId", StringUtils.join(this.uniqueIds, ","));
        params.put("managerEmail", this.managerEmail);
        if (this.companyId != null) {
            params.put("companyId", this.companyId.toString());
        }
        return params;
    }
}

