/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.cloud.api.executor.activities;

import com.kontakt.sdk.android.cloud.api.executor.RequestExecutor;
import com.kontakt.sdk.android.cloud.api.service.ActivitiesService;
import com.kontakt.sdk.android.cloud.exception.KontaktCloudException;
import com.kontakt.sdk.android.cloud.response.CloudCallback;
import com.kontakt.sdk.android.cloud.util.StringUtils;
import com.kontakt.sdk.android.common.model.Activity;
import com.kontakt.sdk.android.common.model.ActivityContext;
import com.kontakt.sdk.android.common.util.SDKPreconditions;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import retrofit2.Call;

public class UpdateActivityRequestExecutor
extends RequestExecutor<String> {
    private final ActivitiesService activitiesService;
    private final UUID id;
    private Activity activity;

    public UpdateActivityRequestExecutor(ActivitiesService activitiesService, UUID id) {
        this.activitiesService = activitiesService;
        this.id = id;
    }

    public UpdateActivityRequestExecutor with(Activity activity) {
        SDKPreconditions.checkNotNull(activity, "Activity cannot be null");
        this.activity = activity;
        return this;
    }

    @Override
    public String execute() throws IOException, KontaktCloudException {
        this.checkPreconditions();
        return (String)super.execute();
    }

    @Override
    public void execute(CloudCallback<String> callback) {
        this.checkPreconditions();
        super.execute(callback);
    }

    @Override
    protected Call<String> prepareCall() {
        return this.activitiesService.update(this.params());
    }

    private void checkPreconditions() {
        SDKPreconditions.checkState(this.id != null, "Cannot update activity - specify activity ID");
        SDKPreconditions.checkState(this.activity != null, "Cannot update activity - specify updated activity");
    }

    @Override
    protected Map<String, String> params() {
        HashMap<String, String> params = new HashMap<String, String>();
        this.addActivityParams(params);
        this.addActivityContextParams(params);
        return params;
    }

    private void addActivityParams(Map<String, String> params) {
        List<UUID> triggersIds;
        params.put("activityId", this.id.toString());
        if (this.activity.getName() != null) {
            params.put("name", this.activity.getName());
        }
        if (this.activity.getType() != null) {
            params.put("type", this.activity.getType().name());
        }
        if ((triggersIds = this.activity.getTriggerIds()) != null && !triggersIds.isEmpty()) {
            params.put("triggerId", StringUtils.join(triggersIds, ","));
        }
    }

    private void addActivityContextParams(Map<String, String> params) {
        ActivityContext context = this.activity.getContext();
        if (context != null) {
            if (context.getHttpMethod() != null) {
                params.put("context.httpMethod", this.activity.getContext().getHttpMethod().name());
            }
            if (context.getUrl() != null) {
                params.put("context.url", this.activity.getContext().getUrl());
            }
            Map<String, String> headers = this.activity.getContext().getHeaders();
            Map<String, String> parameters = this.activity.getContext().getParameters();
            if (headers != null) {
                for (Map.Entry<String, String> entry : headers.entrySet()) {
                    params.put("context.headers." + entry.getKey(), entry.getValue());
                }
            }
            if (parameters != null) {
                for (Map.Entry<String, String> entry : parameters.entrySet()) {
                    params.put("context.headers." + entry.getKey(), entry.getValue());
                }
            }
        }
    }
}

