/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.cloud.api;

import com.kontakt.sdk.android.cloud.api.executor.triggers.CreateTriggerRequestExecutor;
import com.kontakt.sdk.android.cloud.api.executor.triggers.DeleteTriggerRequestExecutor;
import com.kontakt.sdk.android.cloud.api.executor.triggers.TriggersRequestExecutor;
import com.kontakt.sdk.android.cloud.api.executor.triggers.UpdateTriggerRequestExecutor;
import com.kontakt.sdk.android.cloud.api.service.TriggersService;
import com.kontakt.sdk.android.common.model.Trigger;
import com.kontakt.sdk.android.common.util.SDKPreconditions;
import java.util.UUID;

public class TriggersApi {
    private final TriggersService triggersService;

    public TriggersApi(TriggersService triggersService) {
        this.triggersService = triggersService;
    }

    public TriggersRequestExecutor fetch() {
        return new TriggersRequestExecutor(this.triggersService);
    }

    public CreateTriggerRequestExecutor create(Trigger trigger) {
        SDKPreconditions.checkNotNull(trigger, "Trigger cannot be null");
        return new CreateTriggerRequestExecutor(this.triggersService, trigger);
    }

    public UpdateTriggerRequestExecutor update(UUID id) {
        SDKPreconditions.checkNotNull(id, "ID cannot be null");
        return new UpdateTriggerRequestExecutor(this.triggersService, id);
    }

    public DeleteTriggerRequestExecutor delete(UUID id) {
        SDKPreconditions.checkNotNull(id, "ID cannot be null");
        return new DeleteTriggerRequestExecutor(this.triggersService, id);
    }
}

