/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.service;

import com.kontakt.sdk.android.ble.configuration.ScanPeriod;
import com.kontakt.sdk.android.ble.service.ForceScanScheduler;
import com.kontakt.sdk.android.common.log.Logger;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

class ScanController {
    static final ScanController NULL = new ScanController(new Builder()){

        @Override
        void start() {
        }

        @Override
        void stop() {
        }
    };
    static final int MESSAGE_DISMISS = -1;
    static final int MESSAGE_MONITOR_START = 0;
    static final int MESSAGE_MONITOR_STOP = 1;
    private final ScanPeriod scanPeriod;
    private final BlockingQueue<Integer> messageQueue;
    private final Runnable monitorActiveRunner;
    private final Runnable monitorPassiveRunner;
    private final ForceScanScheduler forceScanScheduler;
    private Thread producerThread;
    private Thread consumerThread;

    ScanController(Builder builder) {
        this.scanPeriod = builder.scanPeriod;
        this.monitorActiveRunner = builder.monitorActiveRunner;
        this.monitorPassiveRunner = builder.monitorPassiveRunner;
        this.forceScanScheduler = builder.forceScanScheduler;
        this.messageQueue = new LinkedBlockingQueue<Integer>(1);
    }

    void start() {
        this.producerThread = new Producer(this.messageQueue, this.scanPeriod, "monitor-message-producer-thread");
        this.consumerThread = new Consumer(this.messageQueue, this.monitorActiveRunner, this.monitorPassiveRunner, this.forceScanScheduler, "monitor-message-consumer-thread");
        this.consumerThread.start();
        this.producerThread.start();
    }

    void stop() {
        if (this.producerThread != null) {
            this.producerThread.interrupt();
            this.producerThread = null;
            this.consumerThread = null;
        }
    }

    static class Builder {
        Runnable monitorActiveRunner;
        Runnable monitorPassiveRunner;
        ScanPeriod scanPeriod;
        ForceScanScheduler forceScanScheduler;

        Builder() {
        }

        public Builder setScanActiveRunner(Runnable monitorActiveRunner) {
            this.monitorActiveRunner = monitorActiveRunner;
            return this;
        }

        public Builder setScanPassiveRunner(Runnable monitorPassiveRunner) {
            this.monitorPassiveRunner = monitorPassiveRunner;
            return this;
        }

        public Builder setScanPeriod(ScanPeriod scanPeriod) {
            this.scanPeriod = scanPeriod;
            return this;
        }

        public Builder setForceScanScheduler(ForceScanScheduler forceScanScheduler) {
            this.forceScanScheduler = forceScanScheduler;
            return this;
        }

        public ScanController build() {
            return new ScanController(this);
        }
    }

    private static class Consumer
    extends Thread
    implements Thread.UncaughtExceptionHandler {
        private final BlockingQueue<Integer> messageQueue;
        private final Runnable monitorActiveRunner;
        private final Runnable monitorPassiveRunner;
        private final ForceScanScheduler forceScanScheduler;

        Consumer(BlockingQueue<Integer> messageQueue, Runnable monitorActiveRunner, Runnable monitorPassiveRunner, ForceScanScheduler forceScanScheduler, String name) {
            super(name);
            this.messageQueue = messageQueue;
            this.monitorActiveRunner = monitorActiveRunner;
            this.monitorPassiveRunner = monitorPassiveRunner;
            this.forceScanScheduler = forceScanScheduler;
            this.setUncaughtExceptionHandler(this);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                block6: while (true) {
                    int messageCode = this.messageQueue.take();
                    switch (messageCode) {
                        case 0: {
                            this.monitorActiveRunner.run();
                            this.forceScanScheduler.start();
                            continue block6;
                        }
                        case 1: {
                            this.forceScanScheduler.stop();
                            this.monitorPassiveRunner.run();
                            continue block6;
                        }
                    }
                    break;
                }
                throw new InterruptedException();
            }
            catch (InterruptedException e) {
                Logger.i("Consumer thread interrupted");
                return;
            }
        }

        @Override
        public void uncaughtException(Thread thread, Throwable ex) {
            Logger.e(String.format("%s interrupted, exception swallowed.", thread.getName()));
        }
    }

    private static class Producer
    extends Thread
    implements Thread.UncaughtExceptionHandler {
        private final BlockingQueue<Integer> messageQueue;
        private final long monitorActivePeriod;
        private final long monitorPassivePeriod;
        private final boolean isInstantScanRequested;

        Producer(BlockingQueue<Integer> messageQueue, ScanPeriod scanPeriod, String name) {
            super(name);
            this.messageQueue = messageQueue;
            this.monitorActivePeriod = scanPeriod.getActivePeriod();
            this.monitorPassivePeriod = scanPeriod.getPassivePeriod();
            this.isInstantScanRequested = this.monitorPassivePeriod == 0L;
            this.setUncaughtExceptionHandler(this);
        }

        @Override
        public void run() {
            try {
                boolean isFirstTimeScan = true;
                while (!Thread.currentThread().isInterrupted()) {
                    Logger.i("Starting monitoring");
                    if (isFirstTimeScan) {
                        this.messageQueue.put(0);
                    } else if (!this.isInstantScanRequested) {
                        this.messageQueue.put(0);
                    }
                    TimeUnit.MILLISECONDS.sleep(this.monitorActivePeriod);
                    Logger.i(": Stopping monitoring");
                    if (!this.isInstantScanRequested) {
                        this.messageQueue.put(1);
                    }
                    TimeUnit.MILLISECONDS.sleep(this.monitorPassivePeriod);
                    isFirstTimeScan = false;
                }
                Logger.i("Dismissing consumer thread");
                if (this.isInstantScanRequested) {
                    this.messageQueue.put(1);
                }
                this.messageQueue.put(-1);
            }
            catch (InterruptedException ignored) {
                try {
                    if (this.isInstantScanRequested) {
                        this.messageQueue.put(1);
                    }
                    this.messageQueue.put(-1);
                }
                catch (InterruptedException e) {
                    Logger.i("Monitoring interrupted");
                }
            }
        }

        @Override
        public void uncaughtException(Thread thread, Throwable ex) {
            Logger.e(String.format("%s interrupted, exception swallowed.", thread.getName()));
        }
    }
}

