/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.discovery.secure_profile;

import android.bluetooth.BluetoothDevice;
import com.kontakt.sdk.android.ble.configuration.ScanContext;
import com.kontakt.sdk.android.ble.device.SecureProfile;
import com.kontakt.sdk.android.ble.discovery.FrameDataType;
import com.kontakt.sdk.android.ble.discovery.Parser;
import com.kontakt.sdk.android.ble.discovery.eddystone.InstanceIdResolver;
import com.kontakt.sdk.android.ble.discovery.eddystone.NamespaceIdResolver;
import com.kontakt.sdk.android.common.profile.ISecureProfile;
import com.kontakt.sdk.android.common.util.ConversionUtils;
import java.util.Arrays;

public final class SecureProfileParser
extends Parser<SecureProfile> {
    private static final byte[] KONTAKT_SECURE_PROFILE_PREFIX = new byte[]{22, 106, -2};
    private static final int MIN_SECURE_PROFILE_LENGTH = 14;
    private static final byte PLAIN_DEVICE_IDENTIFIER_PAYLOAD = 2;
    private static final byte SHUFFLED_DEVICE_IDENTIFIER_PAYLOAD = 1;
    private static final NamespaceIdResolver NAMESPACE_RESOLVER = new NamespaceIdResolver(8);
    private static final InstanceIdResolver INSTANCE_ID_RESOLVER = new InstanceIdResolver(18);

    SecureProfileParser(ScanContext scanContext) {
        super(scanContext);
    }

    boolean isValidSecureProfileFrame(byte[] scanRecord) {
        return ConversionUtils.doesArrayContainSubset(scanRecord, KONTAKT_SECURE_PROFILE_PREFIX, 4) && scanRecord.length > 14;
    }

    void parseScanRecord(byte[] scanRecord) {
        this.frameData.clear();
        this.extractFrameData(scanRecord, this.frameData);
    }

    ISecureProfile getSecureProfile(BluetoothDevice device, int rssi) {
        int deviceHashCode = this.hashCodeBuilder.append(device.getAddress()).append((byte[])this.frameData.get((Object)FrameDataType.SCAN_RESPONSE_SERVICE_DATA)).build();
        SecureProfile secureDevice = (SecureProfile)this.devicesCache.get(deviceHashCode);
        if (secureDevice != null) {
            this.update(secureDevice, rssi);
            return secureDevice;
        }
        byte[] serviceData = (byte[])this.frameData.get((Object)FrameDataType.SCAN_RESPONSE_SERVICE_DATA);
        byte[] nameData = (byte[])this.frameData.get((Object)FrameDataType.LOCAL_NAME);
        byte payload = serviceData[2];
        byte batteryLevel = serviceData[6];
        byte txPower = serviceData[7];
        boolean isShuffled = payload == 1;
        String name = this.parseName(nameData);
        String uniqueId = this.parseUniqueId(serviceData, payload);
        String namespace = this.parseNamespace(serviceData, payload);
        String shuffledInstanceId = this.parseShuffledInstanceId(serviceData, payload);
        secureDevice = new SecureProfile.Builder().macAddress(device.getAddress()).name(name).uniqueId(uniqueId).batteryLevel(batteryLevel).firmwareRevision(this.parseFirmwareVersion(serviceData)).txPower(txPower).namespace(namespace).instanceId(shuffledInstanceId).rssi(rssi).shuffled(isShuffled).build();
        this.devicesCache.put(deviceHashCode, secureDevice);
        return secureDevice;
    }

    private void update(SecureProfile device, int rssi) {
        int calculatedRssi = this.rssiCalculator.calculateRssi(device.getMacAddress().hashCode(), rssi);
        device.setRssi(calculatedRssi);
    }

    private String parseName(byte[] nameData) {
        if (nameData == null) {
            return null;
        }
        return new String(nameData);
    }

    private String parseFirmwareVersion(byte[] serviceData) {
        int firmwareVersionMajor = Integer.parseInt(String.valueOf(serviceData[4]), 16);
        int firmwareVersionMinor = Integer.parseInt(String.valueOf(serviceData[5]), 16);
        return String.format("%d.%d", firmwareVersionMajor, firmwareVersionMinor);
    }

    private String parseUniqueId(byte[] serviceData, int payloadId) {
        if (payloadId == 2) {
            return new String(Arrays.copyOfRange(serviceData, 8, serviceData.length));
        }
        return null;
    }

    private String parseNamespace(byte[] serviceData, int payloadId) {
        if (payloadId == 1) {
            return NAMESPACE_RESOLVER.parse(serviceData);
        }
        return null;
    }

    private String parseShuffledInstanceId(byte[] serviceData, int payloadId) {
        if (payloadId == 1) {
            return INSTANCE_ID_RESOLVER.parse(serviceData);
        }
        return null;
    }

    @Override
    protected void disable() {
        if (this.isEnabled) {
            this.isEnabled = false;
        }
    }
}

