/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.discovery.secure_profile;

import android.annotation.TargetApi;
import android.bluetooth.BluetoothDevice;
import android.util.SparseLongArray;
import com.kontakt.sdk.android.ble.cache.FutureShufflesCache;
import com.kontakt.sdk.android.ble.configuration.ActivityCheckConfiguration;
import com.kontakt.sdk.android.ble.configuration.ScanContext;
import com.kontakt.sdk.android.ble.discovery.BluetoothDeviceDiscoverer;
import com.kontakt.sdk.android.ble.discovery.DiscoveryContract;
import com.kontakt.sdk.android.ble.discovery.ShuffledDevicesResolver;
import com.kontakt.sdk.android.ble.discovery.secure_profile.SecureProfileEvent;
import com.kontakt.sdk.android.ble.discovery.secure_profile.SecureProfileParser;
import com.kontakt.sdk.android.ble.util.ReplacingArrayList;
import com.kontakt.sdk.android.ble.util.SafeSparseLongArray;
import com.kontakt.sdk.android.common.profile.ISecureProfile;
import com.kontakt.sdk.android.common.profile.RemoteBluetoothDevice;
import com.kontakt.sdk.android.common.util.SecureProfileUtils;
import java.util.ArrayList;
import java.util.List;

@TargetApi(value=18)
public class SecureProfileDiscoverer
implements BluetoothDeviceDiscoverer,
ShuffledDevicesResolver.ResolveCallback {
    private final ShuffledDevicesResolver shuffleResolver;
    private final List<ISecureProfile> cache;
    private final SecureProfileParser parser;
    private final ActivityCheckConfiguration activityCheckConfiguration;
    private final SparseLongArray secureProfileTimestampArray;
    private final DiscoveryContract discoveryContract;
    private final long deviceUpdateIntervalCallback;
    private long lastUpdateCallbackMillis;

    public SecureProfileDiscoverer(ScanContext scanContext, DiscoveryContract discoveryContract, FutureShufflesCache shufflesCache) {
        this.deviceUpdateIntervalCallback = scanContext.getDeviceUpdateCallbackInterval();
        this.activityCheckConfiguration = scanContext.getActivityCheckConfiguration();
        this.secureProfileTimestampArray = new SafeSparseLongArray();
        this.discoveryContract = discoveryContract;
        this.parser = new SecureProfileParser(scanContext);
        this.cache = new ReplacingArrayList<ISecureProfile>();
        this.shuffleResolver = new ShuffledDevicesResolver(this, shufflesCache);
    }

    SecureProfileDiscoverer(ScanContext scanContext, DiscoveryContract discoveryContract, SparseLongArray secureProfileTimestampArray, List<ISecureProfile> cache, FutureShufflesCache shufflesCache) {
        this.discoveryContract = discoveryContract;
        this.deviceUpdateIntervalCallback = scanContext.getDeviceUpdateCallbackInterval();
        this.activityCheckConfiguration = scanContext.getActivityCheckConfiguration();
        this.secureProfileTimestampArray = secureProfileTimestampArray;
        this.parser = new SecureProfileParser(scanContext);
        this.cache = cache;
        this.shuffleResolver = new ShuffledDevicesResolver(this, shufflesCache);
    }

    @Override
    public void performDiscovery(BluetoothDevice bluetoothDevice, int rssi, byte[] scanResult) {
        if (!this.parser.isValidSecureProfileFrame(scanResult)) {
            return;
        }
        this.parser.parseScanRecord(scanResult);
        ISecureProfile secureProfile = this.parser.getSecureProfile(bluetoothDevice, rssi);
        this.notifySecureProfilePresent(secureProfile);
        if (secureProfile.isShuffled()) {
            this.shuffleResolver.resolve(secureProfile);
        } else {
            this.onResolved(SecureProfileUtils.asRemoteBluetoothDevice(secureProfile));
        }
    }

    @Override
    public void onResolved(RemoteBluetoothDevice device) {
        ISecureProfile secureProfile = SecureProfileUtils.fromRemoteBluetoothDevice(device);
        boolean isDiscovered = this.cache.contains(secureProfile);
        if (!isDiscovered) {
            this.cache.add(secureProfile);
            this.onDiscovered(secureProfile);
        } else {
            this.onUpdated();
        }
    }

    @Override
    public void evictInactiveDevices(long currentTimeMillis) {
        long inactivityTimeout = this.activityCheckConfiguration.getInactivityTimeout();
        for (ISecureProfile secureProfile : new ArrayList<ISecureProfile>(this.cache)) {
            long threshold;
            long timestamp = this.getSecureProfileTimestamp(secureProfile);
            if (timestamp == -1L || (threshold = currentTimeMillis - timestamp) <= inactivityTimeout) continue;
            this.cache.remove(secureProfile);
            this.clearBeforeLost(secureProfile);
            this.onLost(secureProfile);
            this.removeSecureProfileTimestamp(secureProfile);
        }
    }

    private void notifySecureProfilePresent(ISecureProfile secureProfile) {
        this.secureProfileTimestampArray.put(secureProfile.getMacAddress().hashCode(), System.currentTimeMillis());
    }

    private void onDiscovered(ISecureProfile secureProfile) {
        this.discoveryContract.onEvent(SecureProfileEvent.createNewDiscovered(secureProfile, System.currentTimeMillis()));
    }

    private void onUpdated() {
        long currentTimeMillis = System.currentTimeMillis();
        if (currentTimeMillis - this.lastUpdateCallbackMillis > this.deviceUpdateIntervalCallback) {
            this.discoveryContract.onEvent(SecureProfileEvent.createNewUpdated(this.cache, currentTimeMillis));
            this.lastUpdateCallbackMillis = currentTimeMillis;
        }
    }

    private void onLost(ISecureProfile secureProfile) {
        this.discoveryContract.onEvent(SecureProfileEvent.createNewLost(secureProfile, System.currentTimeMillis()));
        this.shuffleResolver.onDeviceLost(SecureProfileUtils.asRemoteBluetoothDevice(secureProfile));
    }

    private void clearBeforeLost(ISecureProfile secureProfile) {
        this.parser.clearRssiCalculation(secureProfile.getMacAddress().hashCode());
    }

    private long getSecureProfileTimestamp(ISecureProfile secureProfile) {
        return this.secureProfileTimestampArray.get(secureProfile.getMacAddress().hashCode(), -1L);
    }

    private void removeSecureProfileTimestamp(ISecureProfile secureProfile) {
        int index = this.secureProfileTimestampArray.indexOfKey(secureProfile.getMacAddress().hashCode());
        if (index >= 0) {
            this.secureProfileTimestampArray.removeAt(index);
        }
    }

    @Override
    public void disable() {
        this.parser.disable();
        this.shuffleResolver.disable();
    }
}

