/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.connection;

import com.kontakt.sdk.android.ble.connection.AuthorizationCallback;
import com.kontakt.sdk.android.ble.connection.ReadListener;
import com.kontakt.sdk.android.ble.connection.WriteBatchListener;
import com.kontakt.sdk.android.ble.connection.WriteListener;
import com.kontakt.sdk.android.ble.dfu.FirmwareUpdateListener;
import com.kontakt.sdk.android.ble.security.auth.AuthToken;
import com.kontakt.sdk.android.cloud.KontaktCloud;
import com.kontakt.sdk.android.common.model.Config;
import com.kontakt.sdk.android.common.model.Firmware;
import com.kontakt.sdk.android.common.model.Preset;
import com.kontakt.sdk.android.common.model.Time;
import com.kontakt.sdk.android.common.profile.DeviceProfile;
import com.kontakt.sdk.android.common.profile.RemoteBluetoothDevice;
import java.util.UUID;

public interface KontaktDeviceConnection {
    public void applyConfig(Config var1, WriteBatchListener<Config> var2);

    public void acceptProfile(Preset var1, WriteBatchListener<Preset> var2);

    public void overwriteMinor(int var1, WriteListener var2);

    public void enableNonConnectableMode(String var1, WriteListener var2);

    public void overwriteMajor(int var1, WriteListener var2);

    public void overwriteProximityUUID(UUID var1, WriteListener var2);

    public void overwritePassword(String var1, WriteListener var2);

    public void overwriteModelName(String var1, WriteListener var2);

    public void overwriteAdvertisingInterval(long var1, WriteListener var3);

    public void overwritePowerLevel(int var1, WriteListener var2);

    public void switchToDeviceProfile(DeviceProfile var1, WriteListener var2);

    public void resetDevice(WriteListener var1);

    public void enableDfuMode(String var1, WriteListener var2);

    public void overwriteUrl(String var1, WriteListener var2);

    public void overwriteNamespaceId(String var1, WriteListener var2);

    public void overwriteInstanceId(String var1, WriteListener var2);

    public void restoreDefaultSettings(String var1, WriteListener var2);

    public void authorize(AuthToken var1, AuthorizationCallback var2);

    public void readAll(AuthToken var1, ReadListener<Config> var2);

    public void readTime(ReadListener<Time> var1);

    public void readLightSensor(ReadListener<Integer> var1);

    public void applySecureConfig(String var1, WriteListener var2);

    public void applySecureConfig(Config var1, AuthToken var2, WriteListener var3);

    public void executeSecureCommand(String var1, WriteListener var2);

    public void updateFirmware(Firmware var1, KontaktCloud var2, FirmwareUpdateListener var3);

    public void updateFirmware(Firmware var1, byte[] var2, KontaktCloud var3, FirmwareUpdateListener var4);

    public void syncTime(WriteListener var1);

    public RemoteBluetoothDevice getDevice();

    public boolean connect();

    public boolean connect(RemoteBluetoothDevice var1);

    public void close();

    public boolean isConnected();

    public boolean isAuthenticated();

    public boolean isClosed();

    public static interface ConnectionListener {
        public void onConnectionOpened();

        public void onAuthenticationSuccess(RemoteBluetoothDevice.Characteristics var1);

        public void onAuthenticationFailure(int var1);

        public void onCharacteristicsUpdated(RemoteBluetoothDevice.Characteristics var1);

        public void onErrorOccured(int var1);

        public void onDisconnected();
    }
}

