/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.connection;

import com.kontakt.sdk.android.ble.connection.ErrorCause;
import com.kontakt.sdk.android.ble.connection.SyncableKontaktDeviceConnectionImpl;
import com.kontakt.sdk.android.ble.connection.WriteListener;
import com.kontakt.sdk.android.cloud.KontaktCloud;
import com.kontakt.sdk.android.cloud.response.CloudCallback;
import com.kontakt.sdk.android.cloud.response.CloudError;
import com.kontakt.sdk.android.cloud.response.CloudHeaders;
import com.kontakt.sdk.android.cloud.response.paginated.Configs;
import com.kontakt.sdk.android.common.model.Config;
import com.kontakt.sdk.android.common.util.SDKPreconditions;

class InternalSecureBeaconWriteListener
implements WriteListener {
    final SyncableKontaktDeviceConnectionImpl.SyncWriteListener syncWriteListener;
    private final KontaktCloud kontaktCloud;
    private final String uniqueId;

    public InternalSecureBeaconWriteListener(SyncableKontaktDeviceConnectionImpl.SyncWriteListener syncWriteListener, KontaktCloud kontaktCloud, String uniqueId) {
        SDKPreconditions.checkNotNullOrEmpty(uniqueId, "unique ID is null or empty");
        this.syncWriteListener = syncWriteListener;
        this.kontaktCloud = kontaktCloud;
        this.uniqueId = uniqueId;
    }

    @Override
    public void onWriteSuccess(WriteListener.WriteResponse response) {
        final Config secureConfig = new Config.Builder().uniqueId(this.uniqueId).secureResponse(response.getExtra()).secureResponseTime(response.getUnixTimestamp()).build();
        this.kontaktCloud.devices().applySecureConfigs(secureConfig).execute(new CloudCallback<Configs>(){

            @Override
            public void onSuccess(Configs response, CloudHeaders headers) {
                InternalSecureBeaconWriteListener.this.syncWriteListener.onSuccess();
            }

            @Override
            public void onError(CloudError error) {
                InternalSecureBeaconWriteListener.this.syncWriteListener.onSyncFailed(error, secureConfig);
            }
        });
    }

    @Override
    public void onWriteFailure(ErrorCause cause) {
        if (this.syncWriteListener != null) {
            this.syncWriteListener.onWriteFailed(cause);
        }
    }
}

