package com.kontakt.sdk.android.common.interfaces;

/**
 * Represents a function that accepts one argument and produces a result that may be
 * validated with exception.
 *
 * @param <T> the type parameter
 * @param <K> the type parameter
 * @param <E> the type parameter
 */
public interface SDKThrowableFunction<T, K, E extends Throwable> {

  /**
   * Apply method.
   *
   * @param object the object to apply
   * @return the object to return after application
   * @throws E the throwable
   */
  K apply(final T object) throws E;
}
