package com.kontakt.sdk.android.cloud.api.executor.presets;

import com.kontakt.sdk.android.cloud.api.PresetsApi;
import com.kontakt.sdk.android.cloud.api.executor.PaginatedRequestExecutor;
import com.kontakt.sdk.android.cloud.api.service.PresetsService;
import com.kontakt.sdk.android.cloud.response.paginated.Presets;
import com.kontakt.sdk.android.common.Order;
import com.kontakt.sdk.android.common.model.OrderBy;
import retrofit2.Call;

/**
 * Request executor provided by {@link PresetsApi}. Use this class if you want to fetch
 * single preset through fluent API in chained fashion, for example:
 * <pre>
 *   <code>
 *   IKontaktCloud kontaktCloud = KontaktCloud.newInstance();
 *   kontaktCloud.presets().fetch().execute();
 *   </code>
 * </pre>
 */
public class PresetsRequestExecutor extends PaginatedRequestExecutor<Presets> {

  private final PresetsService presetsService;

  /**
   * Constructs request executor initialized with corresponding service class.
   *
   * @param presetsService the presets API service.
   */
  public PresetsRequestExecutor(final PresetsService presetsService) {
    this.presetsService = presetsService;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public PresetsRequestExecutor startIndex(int startIndex) {
    super.startIndex(startIndex);
    return this;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public PresetsRequestExecutor maxResult(int maxResult) {
    super.startIndex(maxResult);
    return this;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public PresetsRequestExecutor filter(String query) {
    super.filter(query);
    return this;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public PresetsRequestExecutor orderBy(OrderBy orderBy, Order order) {
    super.orderBy(orderBy, order);
    return this;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public PresetsRequestExecutor eTag(String eTag) {
    super.eTag(eTag);
    return this;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected Call<Presets> prepareCall() {
    final Call<Presets> call;
    if (eTag != null) {
      call = presetsService.getPresets(params(), eTag);
    } else {
      call = presetsService.getPresets(params());
    }
    return call;
  }
}
