package com.kontakt.sdk.android.cloud.api.executor.activities;

import com.kontakt.sdk.android.cloud.CloudConstants;
import com.kontakt.sdk.android.cloud.api.ActivitiesApi;
import com.kontakt.sdk.android.cloud.api.executor.RequestExecutor;
import com.kontakt.sdk.android.cloud.api.service.ActivitiesService;
import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import retrofit2.Call;

/**
 * Request executor provided by {@link ActivitiesApi}. Use this class if you want to delete
 * activities through fluent API in chained fashion, for example:
 * <pre>
 *   <code>
 *   IKontaktCloud kontaktCloud = KontaktCloud.newInstance();
 *   kontaktCloud.activities().delete(ID).execute();
 *   </code>
 * </pre>
 */
public class DeleteActivityRequestExecutor extends RequestExecutor<String> {

  private final ActivitiesService activitiesService;
  private final UUID id;

  /**
   * Constructs request executor initialized with corresponding service class and activity's identifier.
   *
   * @param activitiesService the activities API service.
   * @param id the activity's unique identifier.
   */
  public DeleteActivityRequestExecutor(final ActivitiesService activitiesService, final UUID id) {
    this.activitiesService = activitiesService;
    this.id = id;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected Call<String> prepareCall() {
    return activitiesService.delete(params());
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected Map<String, String> params() {
    return Collections.singletonMap(CloudConstants.Activities.ACTIVITY_ID_PARAMETER, id.toString());
  }
}
