package com.kontakt.sdk.android.cloud.api.executor.actions;

import com.kontakt.sdk.android.cloud.CloudConstants;
import com.kontakt.sdk.android.cloud.api.executor.RequestExecutor;
import com.kontakt.sdk.android.cloud.api.service.ActionsService;
import com.kontakt.sdk.android.cloud.exception.KontaktCloudException;
import com.kontakt.sdk.android.cloud.response.CloudCallback;
import com.kontakt.sdk.android.common.Proximity;
import com.kontakt.sdk.android.common.util.SDKPreconditions;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import retrofit2.Call;

abstract class UpdateActionRequestExecutor extends RequestExecutor<String> {

  protected final ActionsService actionsService;

  protected final UUID id;
  protected Proximity proximity;

  public UpdateActionRequestExecutor(final ActionsService actionsService, final UUID id) {
    this.actionsService = actionsService;
    this.id = id;
  }

  /**
   * Updates the action's proximity.
   *
   * @param proximity the proximity.
   * @return this request executor.
   */
  public UpdateActionRequestExecutor withProximity(final Proximity proximity) {
    SDKPreconditions.checkNotNull(proximity, "proximity cannot be null");
    this.proximity = proximity;
    return this;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String execute() throws IOException, KontaktCloudException {
    checkPreconditions();
    return super.execute();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void execute(final CloudCallback<String> callback) {
    checkPreconditions();
    super.execute(callback);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected Call<String> prepareCall() {
    return actionsService.updateAction(params());
  }

  /**
   * Checks if all pre conditions are satisfied before sending the request.
   */
  protected abstract void checkPreconditions();

  /**
   * {@inheritDoc}
   */
  @Override
  protected Map<String, String> params() {
    final Map<String, String> params = new HashMap<>();
    params.put(CloudConstants.Actions.ACTION_ID_PARAMETER, id.toString());
    if (proximity != null) {
      params.put(CloudConstants.Actions.PROXIMITY_PARAMETER, proximity.name());
    }

    return params;
  }
}
