package com.kontakt.sdk.android.cloud;

import retrofit2.Retrofit;

final class ServicesFactory {

  private Retrofit retrofit;

  private ServicesFactory(final Retrofit retrofit) {
    this.retrofit = retrofit;
  }

  public static ServicesFactory newInstance(final Retrofit retrofit) {
    return new ServicesFactory(retrofit);
  }

  public <E> E createService(final Class<E> serviceToCreate) {
    return retrofit.create(serviceToCreate);
  }
}
