package com.kontakt.sdk.android.ble.service;

import com.kontakt.sdk.android.ble.configuration.ScanContext;
import com.kontakt.sdk.android.ble.manager.listeners.InternalProximityListener;
import com.kontakt.sdk.android.common.profile.DeviceProfile;
import java.util.EnumSet;

final class ServiceScanConfiguration {

  static final Item NULL = new Item(
      new ScanContext.Builder().observedProfiles(EnumSet.of(DeviceProfile.IBEACON, DeviceProfile.EDDYSTONE, DeviceProfile.KONTAKT_SECURE)).build(),
      ScanConfiguration.NULL, ForceScanScheduler.DISABLED, ScanController.NULL);

  private ProximityService.State state = ProximityService.State.IDLE;
  private Item configurationItem = NULL;

  ProximityService.State getState() {
    return state;
  }

  void updateState(ProximityService.State newState) {
    state = newState;
  }

  ScanContext getScanContext() {
    return configurationItem.scanContext;
  }

  ScanConfiguration getScanConfiguration() {
    return configurationItem.scanConfiguration;
  }

  ForceScanScheduler getForceScanScheduler() {
    return configurationItem.forceScanScheduler;
  }

  ScanController getScanController() {
    return configurationItem.scanController;
  }

  void addListener(InternalProximityListener proximityListener) {
    configurationItem.scanConfiguration.addListener(proximityListener);
  }

  void removeListener(InternalProximityListener proximityListener) {
    configurationItem.scanConfiguration.removeListener(proximityListener);
  }

  void clear() {
    configurationItem = NULL;
    state = ProximityService.State.IDLE;
  }

  void add(Item item) {
    configurationItem = item;
  }

  Item get() {
    return configurationItem;
  }

  Item remove() {
    final Item item = configurationItem;
    state = ProximityService.State.IDLE;
    configurationItem = NULL;
    return item;
  }

  static final class Item {
    final ScanContext scanContext;
    final ScanConfiguration scanConfiguration;
    final ForceScanScheduler forceScanScheduler;
    final ScanController scanController;

    Item(ScanContext scanContext, ScanConfiguration scanConfiguration, ForceScanScheduler forceScanScheduler, ScanController scanController) {
      this.scanContext = scanContext;
      this.scanConfiguration = scanConfiguration;
      this.forceScanScheduler = forceScanScheduler;
      this.scanController = scanController;
    }
  }
}
