package com.kontakt.sdk.android.ble.exception;

/**
 * Exception thrown during Kontakt DFU operation
 */
public class KontaktDfuException extends Exception {

  private final static String DEFAULT_MESSAGE = "Kontakt DFU Exception";

  private int errorCode = -1;

  public KontaktDfuException(String message) {
    super(message);
  }

  public KontaktDfuException(int errorCode) {
    super(DEFAULT_MESSAGE);
    this.errorCode = errorCode;
  }

  public KontaktDfuException(String message, int errorCode) {
    super(message);
    this.errorCode = errorCode;
  }

  public int getErrorCode() {
    return errorCode;
  }
}
