package com.kontakt.sdk.android.ble.discovery.eddystone;

import com.kontakt.sdk.android.common.util.ConversionUtils;

public final class EIDResolver implements EddystonePropertyResolver<String> {

  public static final int DEFAULT_EID_START_INDEX = 4;
  private static final int EID_LENGTH = 8;

  private static final int MASK = 0x00FF;
  private static final String FORMAT = "%02x";

  private final StringBuilder stringBuilder = new StringBuilder();

  @Override
  public String parse(byte[] packet) {
    if (packet == null) {
      return null;
    }

    byte[] bytes = ConversionUtils.extractEddystonePacketPayload(packet, DEFAULT_EID_START_INDEX, EID_LENGTH);
    if (bytes == null) {
      return null;
    }

    stringBuilder.setLength(0);

    for (byte byteValue : bytes) {
      stringBuilder.append(String.format(FORMAT, byteValue & MASK));
    }

    return stringBuilder.toString();
  }
}
