/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.common.util;

import android.content.Context;
import android.os.Build;
import com.kontakt.sdk.android.common.util.SDKPreconditions;
import java.util.Arrays;

public final class PermissionsUtils {
    private PermissionsUtils() {
        throw new AssertionError();
    }

    public static void checkPermissions(Context context, String[] permissions) {
        SDKPreconditions.checkNotNull(context, "Context cannot be null");
        SDKPreconditions.checkNotNull(permissions, "Permissions array cannot be null");
        for (String permission2 : permissions) {
            if (context.checkCallingOrSelfPermission(permission2) == 0) continue;
            throw new RuntimeException(String.format("Permission %s is not granted", permission2));
        }
    }

    public static void checkMarshmallowPermissions(Context context, String[] permissions) {
        if (Build.VERSION.SDK_INT >= 23) {
            PermissionsUtils.checkPermissions(context, permissions);
        }
    }

    public static void checkAtLeastOnePermissionGranted(Context context, String[] permissions) {
        SDKPreconditions.checkNotNull(context, "Context cannot be null");
        SDKPreconditions.checkNotNull(permissions, "Permissions array cannot be null");
        for (String permission2 : permissions) {
            if (context.checkCallingOrSelfPermission(permission2) != 0) continue;
            return;
        }
        throw new RuntimeException(String.format("At least one of %s must be granted for Android Marshmallow or higher", Arrays.toString(permissions)));
    }

    public static void checkAtLeastOneMarshmallowPermissionGranted(Context context, String[] permissions) {
        if (Build.VERSION.SDK_INT >= 23) {
            PermissionsUtils.checkAtLeastOnePermissionGranted(context, permissions);
        }
    }
}

