/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.common.util;

import android.util.SparseArray;
import java.nio.ByteBuffer;
import java.util.regex.Pattern;

public final class EddystoneUtils {
    private static final SparseArray<String> URL_SCHEME_PREFIXES;
    private static final SparseArray<String> URL_SCHEME_SUFFIXES;
    private static final int MASK = 255;
    private static final int SUFFIX_MASK = 15;
    private static final String NULL_CHAR = "\u0000";
    private static final String HEX_STRING_FORMAT = "%02x";
    private static final int LOWEST_ASCII_PRINTABLE_VALUE = 32;
    private static final int HIGHEST_ASCII_PRINTABLE_VALUE = 127;
    private static final char[] HEX;
    private static final Pattern HEX_PATTERN;

    private EddystoneUtils() {
    }

    public static String toStringFromHex(byte[] value) {
        StringBuilder builder = new StringBuilder();
        for (byte aValue : value) {
            int b = aValue & 0xFF;
            builder.append(String.format(HEX_STRING_FORMAT, b));
        }
        return builder.toString();
    }

    public static String toHexString(byte[] bytes) {
        char[] chars = new char[bytes.length * 2];
        for (int i = 0; i < bytes.length; ++i) {
            int c = bytes[i] & 0xFF;
            chars[i * 2] = HEX[c >>> 4];
            chars[i * 2 + 1] = HEX[c & 0xF];
        }
        return new String(chars).toLowerCase();
    }

    public static String toAlignedString(String arg, int targetLength) {
        int length = arg.getBytes().length;
        if (length < targetLength) {
            StringBuilder builder = new StringBuilder();
            for (int i = length; i < targetLength; ++i) {
                builder.append(NULL_CHAR);
            }
            builder.append(arg);
            return builder.toString();
        }
        return arg;
    }

    public static String deserializeUrl(byte[] values) {
        if (values == null || values.length == 0) {
            return null;
        }
        String prefix = EddystoneUtils.extractPrefix(values[0]);
        StringBuilder urlBuilder = new StringBuilder();
        urlBuilder.append(prefix);
        for (int i = 1; i < values.length; ++i) {
            char ch = (char)values[i];
            if (EddystoneUtils.isAsciiPrintable(ch)) {
                urlBuilder.append(ch);
                continue;
            }
            String suffixFromByte = EddystoneUtils.getExtractSuffixFromByte(values[i]);
            if (suffixFromByte == null) continue;
            urlBuilder.append(suffixFromByte);
        }
        return urlBuilder.toString();
    }

    public static byte[] serializeUrl(String url) {
        int key;
        int i;
        EddystoneUtils.isAllASCII(url);
        for (i = 0; i < URL_SCHEME_PREFIXES.size(); ++i) {
            key = URL_SCHEME_PREFIXES.keyAt(i);
            String prefix = (String)URL_SCHEME_PREFIXES.get(key);
            int prefixSectionIndexOf = url.indexOf(prefix);
            if (prefixSectionIndexOf == -1) continue;
            byte[] prefixInBytes = ByteBuffer.allocate(4).putInt(key).array();
            url = url.replace(prefix, new String(prefixInBytes, 3, 1));
        }
        for (i = 0; i < URL_SCHEME_SUFFIXES.size(); ++i) {
            key = URL_SCHEME_SUFFIXES.keyAt(i);
            String suffix = (String)URL_SCHEME_SUFFIXES.get(key);
            int suffixSectionIndexOf = url.indexOf(suffix);
            if (suffixSectionIndexOf == -1) continue;
            byte[] suffixInBytes = ByteBuffer.allocate(4).putInt(key).array();
            url = url.replace(suffix, new String(suffixInBytes, 3, 1));
        }
        return url.getBytes();
    }

    public static String fromHexedUrlToUrl(String hex) {
        byte[] decode = EddystoneUtils.decodeHexedUrl(hex.trim());
        return new String(decode).trim();
    }

    public static byte[] hexStringToByteArray(String s) {
        int len = s.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len - 1; i += 2) {
            data[i / 2] = (byte)((Character.digit(s.charAt(i), 16) << 4) + Character.digit(s.charAt(i + 1), 16));
        }
        return data;
    }

    public static boolean isStringOnlyHex(String input) {
        return HEX_PATTERN.matcher(input).matches();
    }

    private static byte[] decodeHexedUrl(String hex) {
        int i;
        String[] list = EddystoneUtils.splitStringEvery(hex, 2);
        ByteBuffer buffer = ByteBuffer.allocate(36);
        String firstByte = list[0];
        String prefix = EddystoneUtils.extractPrefix(Byte.parseByte(firstByte, 16));
        if (prefix != null) {
            int prefixLength = prefix.length();
            for (i = 0; i < prefixLength; ++i) {
                buffer.put((byte)prefix.charAt(i));
            }
        }
        int length = list.length;
        for (i = 1; i < length; ++i) {
            byte parseByte = Byte.parseByte(list[i], 16);
            boolean asciiPrintable = EddystoneUtils.isAsciiPrintable((char)parseByte);
            if (asciiPrintable) {
                buffer.put(parseByte);
                continue;
            }
            String suffixFromByte = EddystoneUtils.getExtractSuffixFromByte(parseByte);
            if (suffixFromByte == null) continue;
            int suffixLength = suffixFromByte.length();
            for (int j = 0; j < suffixLength; ++j) {
                buffer.put((byte)suffixFromByte.charAt(j));
            }
        }
        return buffer.array();
    }

    private static String[] splitStringEvery(String s, int interval) {
        int arrayLength = (int)Math.ceil((double)s.length() / (double)interval);
        String[] result = new String[arrayLength];
        int j = 0;
        int lastIndex = result.length - 1;
        for (int i = 0; i < lastIndex; ++i) {
            result[i] = s.substring(j, j + interval);
            j += interval;
        }
        result[lastIndex] = s.substring(j);
        return result;
    }

    private static String extractPrefix(byte prefixByte) {
        int prefixArrayValue = prefixByte & 0xFF;
        return (String)URL_SCHEME_PREFIXES.get(prefixArrayValue);
    }

    private static String getExtractSuffixFromByte(byte b) {
        return (String)URL_SCHEME_SUFFIXES.get(b & 0xF);
    }

    private static boolean isAsciiPrintable(char ch) {
        return ch >= ' ' && ch < '\u007f';
    }

    public static void isAllASCIIPrintable(String input) {
        boolean isASCII = true;
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (EddystoneUtils.isAsciiPrintable(c)) continue;
            isASCII = false;
            break;
        }
        if (!isASCII) {
            throw new IllegalArgumentException("Provided input must be all ASCII printable");
        }
    }

    private static void isAllASCII(String input) {
        boolean isASCII = true;
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (c <= '\u007f') continue;
            isASCII = false;
            break;
        }
        if (!isASCII) {
            throw new IllegalArgumentException("Provided url must be ASCII. Input: " + input);
        }
    }

    static {
        HEX = "0123456789ABCDEF".toCharArray();
        HEX_PATTERN = Pattern.compile("[0-9a-fA-F]+");
        URL_SCHEME_PREFIXES = new SparseArray(4);
        URL_SCHEME_PREFIXES.put(0, (Object)"http://www.");
        URL_SCHEME_PREFIXES.put(1, (Object)"https://www.");
        URL_SCHEME_PREFIXES.put(2, (Object)"http://");
        URL_SCHEME_PREFIXES.put(3, (Object)"https://");
        URL_SCHEME_SUFFIXES = new SparseArray(14);
        URL_SCHEME_SUFFIXES.put(0, (Object)".com/");
        URL_SCHEME_SUFFIXES.put(1, (Object)".org/");
        URL_SCHEME_SUFFIXES.put(2, (Object)".edu/");
        URL_SCHEME_SUFFIXES.put(3, (Object)".net/");
        URL_SCHEME_SUFFIXES.put(4, (Object)".info/");
        URL_SCHEME_SUFFIXES.put(5, (Object)".biz/");
        URL_SCHEME_SUFFIXES.put(6, (Object)".gov/");
        URL_SCHEME_SUFFIXES.put(7, (Object)".com");
        URL_SCHEME_SUFFIXES.put(8, (Object)".org");
        URL_SCHEME_SUFFIXES.put(9, (Object)".edu");
        URL_SCHEME_SUFFIXES.put(10, (Object)".net");
        URL_SCHEME_SUFFIXES.put(11, (Object)".info");
        URL_SCHEME_SUFFIXES.put(12, (Object)".biz");
        URL_SCHEME_SUFFIXES.put(13, (Object)".gov");
    }
}

