/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.common.model;

import android.os.Parcel;
import android.os.Parcelable;
import com.kontakt.sdk.android.common.model.TriggerContext;
import com.kontakt.sdk.android.common.model.TriggerType;
import com.kontakt.sdk.android.common.util.HashCodeBuilder;
import com.kontakt.sdk.android.common.util.SDKEqualsBuilder;
import java.io.Serializable;
import java.util.List;
import java.util.UUID;

public class Trigger
implements Parcelable {
    public static final Parcelable.Creator<Trigger> CREATOR = new Parcelable.Creator<Trigger>(){

        public Trigger createFromParcel(Parcel source) {
            return new Trigger(source);
        }

        public Trigger[] newArray(int size) {
            return new Trigger[size];
        }
    };
    private final UUID id;
    private final String name;
    private final List<String> activityId;
    private final TriggerType type;
    private final TriggerContext context;

    public static Builder builder() {
        return new Builder();
    }

    Trigger(Builder builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.type = builder.type;
        this.activityId = builder.activityIds;
        this.context = builder.context;
    }

    protected Trigger(Parcel in) {
        this.id = (UUID)in.readSerializable();
        this.name = in.readString();
        this.activityId = in.createStringArrayList();
        int tmpType = in.readInt();
        this.type = tmpType == -1 ? null : TriggerType.values()[tmpType];
        this.context = (TriggerContext)in.readParcelable(TriggerContext.class.getClassLoader());
    }

    private Trigger() {
        this(new Builder());
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !(object instanceof Trigger)) {
            return false;
        }
        Trigger trigger = (Trigger)object;
        return SDKEqualsBuilder.start().equals(this.id, trigger.id).equals(this.name, trigger.name).equals((Object)this.type, (Object)trigger.type).equals(this.context, trigger.context).result();
    }

    public int hashCode() {
        return HashCodeBuilder.init().append(this.id).append(this.name).append((Object)this.type).append(this.context).build();
    }

    public String toString() {
        return this.type.name() + " [" + this.context.getTrackingId() + "]";
    }

    public UUID getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public TriggerType getType() {
        return this.type;
    }

    public TriggerContext getContext() {
        return this.context;
    }

    public List<String> getActivityIds() {
        return this.activityId;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeSerializable((Serializable)this.id);
        dest.writeString(this.name);
        dest.writeStringList(this.activityId);
        dest.writeInt(this.type == null ? -1 : this.type.ordinal());
        dest.writeParcelable((Parcelable)this.context, flags);
    }

    public static class Builder {
        UUID id;
        String name;
        TriggerType type;
        TriggerContext context;
        List<String> activityIds;

        public Builder id(UUID id) {
            this.id = id;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder type(TriggerType type) {
            this.type = type;
            return this;
        }

        public Builder context(TriggerContext context) {
            this.context = context;
            return this;
        }

        public Builder activityIds(List<String> activityId) {
            this.activityIds = activityId;
            return this;
        }

        public Trigger build() {
            return new Trigger(this);
        }
    }
}

