/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.common.model;

import android.os.Parcel;
import android.os.Parcelable;
import com.kontakt.sdk.android.common.model.PowerSavingFeature;
import java.util.ArrayList;
import java.util.List;

public class PowerSaving
implements Parcelable {
    public static final Parcelable.Creator<PowerSaving> CREATOR = new Parcelable.Creator<PowerSaving>(){

        public PowerSaving createFromParcel(Parcel source) {
            return new PowerSaving(source);
        }

        public PowerSaving[] newArray(int size) {
            return new PowerSaving[size];
        }
    };
    private final List<PowerSavingFeature> features;
    private final long moveSuspendTimeout;
    private final int lightSensorThreshold;
    private final int lightSensorHysteresis;
    private final long lightSensorSamplingInterval;

    PowerSaving(Builder builder) {
        this.features = builder.features;
        this.moveSuspendTimeout = builder.moveSuspendTimeout;
        this.lightSensorThreshold = builder.lightSensorThreshold;
        this.lightSensorHysteresis = builder.lightSensorHysteresis;
        this.lightSensorSamplingInterval = builder.lightSensorSamplingInterval;
    }

    protected PowerSaving(Parcel in) {
        this.features = new ArrayList<PowerSavingFeature>();
        in.readList(this.features, PowerSavingFeature.class.getClassLoader());
        this.moveSuspendTimeout = in.readLong();
        this.lightSensorThreshold = in.readInt();
        this.lightSensorHysteresis = in.readInt();
        this.lightSensorSamplingInterval = in.readLong();
    }

    private PowerSaving() {
        this(new Builder());
    }

    public List<PowerSavingFeature> getFeatures() {
        return this.features;
    }

    public long getMoveSuspendTimeout() {
        return this.moveSuspendTimeout;
    }

    public int getLightSensorThreshold() {
        return this.lightSensorThreshold;
    }

    public int getLightSensorHysteresis() {
        return this.lightSensorHysteresis;
    }

    public long getLightSensorSamplingInterval() {
        return this.lightSensorSamplingInterval;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PowerSaving that = (PowerSaving)o;
        if (this.moveSuspendTimeout != that.moveSuspendTimeout) {
            return false;
        }
        if (this.lightSensorThreshold != that.lightSensorThreshold) {
            return false;
        }
        if (this.lightSensorHysteresis != that.lightSensorHysteresis) {
            return false;
        }
        if (this.lightSensorSamplingInterval != that.lightSensorSamplingInterval) {
            return false;
        }
        return this.features != null ? this.features.equals(that.features) : that.features == null;
    }

    public int hashCode() {
        int result = this.features != null ? this.features.hashCode() : 0;
        result = 31 * result + (int)(this.moveSuspendTimeout ^ this.moveSuspendTimeout >>> 32);
        result = 31 * result + this.lightSensorThreshold;
        result = 31 * result + this.lightSensorHysteresis;
        result = 31 * result + (int)(this.lightSensorSamplingInterval ^ this.lightSensorSamplingInterval >>> 32);
        return result;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeList(this.features);
        dest.writeLong(this.moveSuspendTimeout);
        dest.writeInt(this.lightSensorThreshold);
        dest.writeInt(this.lightSensorHysteresis);
        dest.writeLong(this.lightSensorSamplingInterval);
    }

    public int describeContents() {
        return 0;
    }

    public static class Builder {
        List<PowerSavingFeature> features = new ArrayList<PowerSavingFeature>();
        long moveSuspendTimeout = -1L;
        int lightSensorThreshold = -1;
        int lightSensorHysteresis = -1;
        long lightSensorSamplingInterval = -1L;

        public Builder features(List<PowerSavingFeature> features) {
            this.features.clear();
            this.features.addAll(features);
            return this;
        }

        public Builder moveSuspendTimeout(long moveSuspendTimeout) {
            this.moveSuspendTimeout = moveSuspendTimeout;
            return this;
        }

        public Builder lightSensorThreshold(int lightSensorThreshold) {
            this.lightSensorThreshold = lightSensorThreshold;
            return this;
        }

        public Builder lightSensorHysteresis(int lightSensorHysteresis) {
            this.lightSensorHysteresis = lightSensorHysteresis;
            return this;
        }

        public Builder lightSensorSamplingInterval(long lightSensorSamplingInterval) {
            this.lightSensorSamplingInterval = lightSensorSamplingInterval;
            return this;
        }

        public PowerSaving build() {
            return new PowerSaving(this);
        }
    }
}

