/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.common.model;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.gson.annotations.SerializedName;
import com.kontakt.sdk.android.common.util.HashCodeBuilder;
import com.kontakt.sdk.android.common.util.SDKEqualsBuilder;

public class Namespace
implements Parcelable {
    public static final Parcelable.Creator<Namespace> CREATOR = new Parcelable.Creator<Namespace>(){

        public Namespace createFromParcel(Parcel source) {
            return new Namespace(source);
        }

        public Namespace[] newArray(int size) {
            return new Namespace[size];
        }
    };
    @SerializedName(value="namespace")
    private String namespaceId;
    @SerializedName(value="secureNamespace")
    private String secureNamespaceId;
    private boolean shuffled;
    private boolean shared;

    private Namespace() {
        this(new Builder());
    }

    public static Builder builder() {
        return new Builder();
    }

    Namespace(Builder builder) {
        this.namespaceId = builder.namespaceId;
        this.secureNamespaceId = builder.secureNamespaceId;
        this.shuffled = builder.shuffled;
        this.shared = builder.shared;
    }

    protected Namespace(Parcel in) {
        this.namespaceId = in.readString();
        this.secureNamespaceId = in.readString();
        this.shuffled = in.readByte() != 0;
        this.shared = in.readByte() != 0;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof Namespace)) {
            return false;
        }
        if (o == this) {
            return true;
        }
        Namespace other = (Namespace)o;
        return SDKEqualsBuilder.start().equals(this.namespaceId, other.namespaceId).equals(this.secureNamespaceId, other.secureNamespaceId).equals(this.shuffled, other.shuffled).equals(this.shared, other.shared).result();
    }

    public int hashCode() {
        return HashCodeBuilder.init().append(this.namespaceId).append(this.secureNamespaceId).append(this.shuffled).append(this.shared).build();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.namespaceId);
        dest.writeString(this.secureNamespaceId);
        dest.writeByte(this.shuffled ? (byte)1 : 0);
        dest.writeByte(this.shared ? (byte)1 : 0);
    }

    public String getNamespaceId() {
        return this.namespaceId;
    }

    public String getSecureNamespaceId() {
        return this.secureNamespaceId;
    }

    public boolean isShuffled() {
        return this.shuffled;
    }

    public boolean isShared() {
        return this.shared;
    }

    public static class Builder {
        String namespaceId;
        String secureNamespaceId;
        boolean shuffled;
        boolean shared;

        public Builder namespace(String namespaceId) {
            this.namespaceId = namespaceId;
            return this;
        }

        public Builder secureNamespace(String secureNamespaceId) {
            this.secureNamespaceId = secureNamespaceId;
            return this;
        }

        public Builder shuffled(boolean shuffled) {
            this.shuffled = shuffled;
            return this;
        }

        public Builder shared(boolean shared) {
            this.shared = shared;
            return this;
        }

        public Namespace build() {
            return new Namespace(this);
        }
    }
}

