/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.cloud.api.executor.triggers;

import com.kontakt.sdk.android.cloud.api.executor.RequestExecutor;
import com.kontakt.sdk.android.cloud.api.service.TriggersService;
import com.kontakt.sdk.android.cloud.exception.KontaktCloudException;
import com.kontakt.sdk.android.cloud.response.CloudCallback;
import com.kontakt.sdk.android.common.model.Trigger;
import com.kontakt.sdk.android.common.util.SDKPreconditions;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import retrofit2.Call;

public class UpdateTriggerRequestExecutor
extends RequestExecutor<String> {
    private final TriggersService triggersService;
    private final UUID id;
    private Trigger trigger;

    public UpdateTriggerRequestExecutor(TriggersService triggersService, UUID id) {
        this.triggersService = triggersService;
        this.id = id;
    }

    public UpdateTriggerRequestExecutor with(Trigger trigger) {
        SDKPreconditions.checkNotNull(trigger, "Trigger cannot be null");
        this.trigger = trigger;
        return this;
    }

    @Override
    public String execute() throws IOException, KontaktCloudException {
        this.checkPreconditions();
        return (String)super.execute();
    }

    @Override
    public void execute(CloudCallback<String> callback) {
        this.checkPreconditions();
        super.execute(callback);
    }

    @Override
    protected Call<String> prepareCall() {
        return this.triggersService.update(this.params());
    }

    private void checkPreconditions() {
        SDKPreconditions.checkState(this.trigger != null, "cannot update trigger - specify trigger to update");
    }

    @Override
    protected Map<String, String> params() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("triggerId", this.id.toString());
        if (this.trigger.getName() != null) {
            params.put("name", this.trigger.getName());
        }
        if (this.trigger.getType() != null) {
            params.put("type", this.trigger.getType().name());
        }
        if (this.trigger.getContext() != null) {
            if (this.trigger.getContext().getTrackingId() != null) {
                params.put("context.trackingId", this.trigger.getContext().getTrackingId());
            }
            if (this.trigger.getContext().getProximity() != null) {
                params.put("context.proximity", this.trigger.getContext().getProximity().name());
            }
            if (this.trigger.getContext().getSourceId() != null) {
                params.put("context.sourceId", this.trigger.getContext().getSourceId());
            }
        }
        return params;
    }
}

